--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


-- Work out the lift and drag on each lift/drag surface
--
separate(AEROPLANE.MOVE_DELTA)
	procedure SET_SURFACE_LIFT_DRAG(MAIN_WINGS_K_ONLY : BOOLEAN) is

	    SIN_DIHEDRAL_ANGLE	: SCALE_TYPE renames A_T.SIN_DIHEDRAL_ANGLE;
	    COS_DIHEDRAL_ANGLE	: SCALE_TYPE renames A_T.COS_DIHEDRAL_ANGLE;
	    SIN_SWEEP_ANGLE	: SCALE_TYPE renames A_T.SIN_SWEEP_ANGLE;
	    COS_SWEEP_ANGLE	: SCALE_TYPE renames A_T.COS_SWEEP_ANGLE;

	    generic
		X		: SURFACE;
		V_J, V_K	: METRES_PER_SECOND;
		L_I, L_J, L_K	: METRES_PER_SECOND_SQUARED;
		AEROLONS_EFFECT : SCALE_TYPE;
		CL_ALPHA	: SCALE_TYPE;
		LD_OUTPUTS	: in out LIFT_DRAG_CURVE_MANAGER.LIFT_DRAG_OUTPUTS;
	    package DO_MAIN_WING is
		AoA		: RADIANS;
	    end;

	    package body DO_MAIN_WING is

		D_X		: OBJECT_PHYSICS.ACCELERATION renames D(X);
		L_X		: OBJECT_PHYSICS.ACCELERATION renames L(X);
		V_X		: OBJECT_PHYSICS.VELOCITY renames V(X);

		AIR_SPEED	: constant METRES_PER_SECOND := LENGTH(V_X);

		CD		: SCALE_TYPE renames LD_OUTPUTS.CD;
		CL		: SCALE_TYPE renames LD_OUTPUTS.CL;

		MULTIPLIER	: SCALE_TYPE;
		D_MULTIPLIER	: SCALE_TYPE;
		L_MULTIPLIER	: SCALE_TYPE;
		TANGENT_SPEED	: METRES_PER_SECOND;

	    begin

		if AIR_SPEED = 0.0 then
		    AoA := 0.0;
		    D_X := (0.0, 0.0, 0.0);
		    L_X := (0.0, 0.0, 0.0);
		    goto DONE;
		end if;

		GET_AOA_ETC(V_J, V_K, AoA, TANGENT_SPEED);

		MAIN_WING_LIFT_DRAG_INPUTS.ANGLE_OF_ATTACK  := AoA;
		MAIN_WING_LIFT_DRAG_INPUTS.CL_ALPHA	    := CL_ALPHA;
		MAIN_WING_LIFT_DRAG_INPUTS.AEROLONS	    := ROLL_CONTROL*AEROLONS_EFFECT;

		LIFT_DRAG_CURVE_MANAGER.GET_LIFT_AND_DRAG(
		    MAIN_WING_LIFT_DRAG_INPUTS,
		    LD_OUTPUTS);

		L_MULTIPLIER := CL*(MAIN_WING_LD_MULTIPLIER*(SCALE_TYPE(AIR_SPEED)**2));
		D_MULTIPLIER := CD*(MAIN_WING_LD_MULTIPLIER*(SCALE_TYPE(AIR_SPEED)**2));

--		Because of how critical these few lines of code are,
--		they have been expanded for cpu efficiency reasons
--
		D_X := (V_X*SCALE_TYPE'(1.0/SCALE_TYPE(AIR_SPEED)))
			/SECONDS(1.0);
--
--		L_X.I	:= L_I;
--		L_X.J	:= L_J;
--		L_X.K	:= L_K;
--
--		CROSS(D_X, L_X);
--
--		MULTIPLY(D_MULTIPLIER, D_X);
--		MULTIPLY(L_MULTIPLIER, L_X);
--
		declare
		    subtype SOME_FLOAT is METRES_PER_SECOND_SQUARED;
		    A1 : SOME_FLOAT renames D_X.I;
		    A2 : SOME_FLOAT renames D_X.J;
		    A3 : SOME_FLOAT renames D_X.K;
		    B1 : SOME_FLOAT renames L_I;
		    B2 : SOME_FLOAT renames L_J;
		    B3 : SOME_FLOAT renames L_K;
		begin
		    L_X.K := (A1*B2-A2*B1)*L_MULTIPLIER;
		    if not MAIN_WINGS_K_ONLY then
			L_X.I := (A2*B3-A3*B2)*L_MULTIPLIER;
			L_X.J := (A3*B1-A1*B3)*L_MULTIPLIER;
			D_X.I := D_X.I*D_MULTIPLIER;
			D_X.J := D_X.J*D_MULTIPLIER;
		    end if;
		    D_X.K := D_X.K*D_MULTIPLIER; -- don't move earlier, is A3
		end;
	<<DONE>>
		null;
	    end;

	begin

	-- RIGHT_WING
	    declare
		package DO_RIGHT_WING is new
	    DO_MAIN_WING(RW,
		V_J		=> (V(RW).J*COS_SWEEP_ANGLE +
				    V(RW).I*SIN_SWEEP_ANGLE  ),
		V_K		=> (V(RW).K*COS_DIHEDRAL_ANGLE -
				    V(RW).I*SIN_DIHEDRAL_ANGLE),

--		L_I		=> METRES_PER_SECOND_SQUARED( COS_SWEEP_ANGLE),
--		L_J		=> METRES_PER_SECOND_SQUARED(-SIN_SWEEP_ANGLE),
		L_I		=> 1.0,
		L_J		=> 0.0,
		L_K		=> METRES_PER_SECOND_SQUARED( SIN_DIHEDRAL_ANGLE),
		AEROLONS_EFFECT => -1.0,
		CL_ALPHA	=> AEROPLANE_STATUS.CL_ALPHA_RIGHT,
		LD_OUTPUTS	=> AEROPLANE_STATUS.CD_CL_RIGHT);
	    begin
		null;
	    end;

	-- LEFT_WING

	    declare
		package DO_LEFT_WING is new
	    DO_MAIN_WING(LW,
		V_J		=> (V(LW).J*COS_SWEEP_ANGLE -
				    V(LW).I*SIN_SWEEP_ANGLE  ),
		V_K		=> (V(LW).K*COS_DIHEDRAL_ANGLE +
				    V(LW).I*SIN_DIHEDRAL_ANGLE),

--		L_I		=> METRES_PER_SECOND_SQUARED( COS_SWEEP_ANGLE),
--		L_J		=> METRES_PER_SECOND_SQUARED( SIN_SWEEP_ANGLE),
		L_I		=> 1.0,
		L_J		=> 0.0,
		L_K		=> METRES_PER_SECOND_SQUARED(-SIN_DIHEDRAL_ANGLE), 
		AEROLONS_EFFECT => +1.0,
		CL_ALPHA	=> AEROPLANE_STATUS.CL_ALPHA_LEFT,
		LD_OUTPUTS	=> AEROPLANE_STATUS.CD_CL_LEFT);
	    begin
		AEROPLANE_STATUS.AOA     := DO_LEFT_WING.AOA;
		AEROPLANE_STATUS.AOA_MAX :=
		    SCALE_TYPE(AEROPLANE_STATUS.CD_CL_LEFT.AOA_MAX);
	    end;

	end; pragma SUPPRESS_ALL;
