--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(AEROPLANE)
    procedure SET_O_VELOCITY(
	O			: OBJECTS.OBJECT_TYPE;
	AEROPLANE_STATUS	: in out AEROPLANE_STATUS_TYPE)
    is
	WORLD_RELATIVE_VELOCITY : WORLD_PHYSICS.VELOCITY
	    renames O.VELOCITY;

	OV : OBJECT_PHYSICS.VELOCITY
	    renames AEROPLANE_STATUS.OBJECT_RELATIVE_VELOCITY;

	WRV_I : constant METRES_PER_SECOND := WORLD_RELATIVE_VELOCITY.I;
	WRV_J : constant METRES_PER_SECOND := WORLD_RELATIVE_VELOCITY.J;
	WRV_K : constant METRES_PER_SECOND := WORLD_RELATIVE_VELOCITY.K;
    begin
	OV.I := WRV_I*SCALE_TYPE(O.ORIENTATION.I.I) +
		WRV_J*SCALE_TYPE(O.ORIENTATION.I.J) +
		WRV_K*SCALE_TYPE(O.ORIENTATION.I.K) ;

	OV.J := WRV_I*SCALE_TYPE(O.ORIENTATION.J.I) +
		WRV_J*SCALE_TYPE(O.ORIENTATION.J.J) +
		WRV_K*SCALE_TYPE(O.ORIENTATION.J.K) ;

	OV.K := WRV_I*SCALE_TYPE(O.ORIENTATION.K.I) +
		WRV_J*SCALE_TYPE(O.ORIENTATION.K.J) +
		WRV_K*SCALE_TYPE(O.ORIENTATION.K.K) ;

    end;
