--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(AEROPLANE.MOVE_DELTA)
	procedure SET_O_PITCH_YAW_RATE is

-- New PITCH and YAW rates
--
--  Basically the tail surfaces have sufficient leverage to stay flying at 0 AoA
--  into what ever airflow is happening, so there is no real need to calculate
--  a "rate", except that the yaw rate has to get fed into the wing speed and
--  there is a maximum rate at which the surface will blow into place.
--
	    function COMPUTE_RATE(
		    SURFACE_ANGLE   : RADIANS;
		    V_ACROSS,
		    V_ALONG	    : METRES_PER_SECOND)
		return RADIANS_PER_SECOND
	    is
		IN_X_SECONDS : constant SECONDS := 0.1;

		SIN_SURFACE_ANGLE : constant SCALE_TYPE
		    := SIN(SURFACE_ANGLE);

		COS_SURFACE_ANGLE : constant SCALE_TYPE
		    := COS(SURFACE_ANGLE);

		PERPENDICULAR_TO_SURFACE : constant METRES_PER_SECOND
		    := V_ACROSS*COS_SURFACE_ANGLE+V_ALONG*SIN_SURFACE_ANGLE;

		ACROSS_COMPONENT : constant METRES_PER_SECOND
		    := PERPENDICULAR_TO_SURFACE*COS_SURFACE_ANGLE;

		MAX_RATE : RADIANS_PER_SECOND
		    := RADIANS_PER_SECOND(
			    SCALE_TYPE(ACROSS_COMPONENT)/
			    SCALE_TYPE(A_T.TAIL_MOMENT_LENGTH));

		I   : constant SCALE_TYPE
		    := SCALE_TYPE(V_ACROSS);

		J   : constant SCALE_TYPE
		    := SCALE_TYPE(V_ALONG);

		S   : constant SCALE_TYPE
		    := SQRT(I*I+J*J);

		RATE : RADIANS_PER_SECOND;

	    begin

		if S <= 0.01 then return MAX_RATE; end if;

		RATE := (SCALE_TYPE_TRIG.ASIN_ACOS(I/S, -J/S) - 
			    SURFACE_ANGLE*AEROPLANE_STATUS.TAIL_EFFECTIVENESS)
			/IN_X_SECONDS;

		if abs(RATE) < abs(MAX_RATE) then
		    return RATE;
		else
		    return MAX_RATE;
		end if;
	    end;

	begin
	    -- Make the rates enough to cancel out the airflow across
	    -- the tail, but not so much as too overshot before rate is
	    -- calculated again.
	    --
	    AEROPLANE_STATUS.PITCH_RATE :=
	        COMPUTE_RATE(
		     PITCH_CONTROL*A_T.MAX_ELEVATOR_DEFLECTION,
		     OBJECT_RELATIVE_VELOCITY.K,
		    -OBJECT_RELATIVE_VELOCITY.J);

	    AEROPLANE_STATUS.YAW_RATE :=
	        COMPUTE_RATE(
		     YAW_CONTROL*A_T.MAX_RUDDER_DEFLECTION,
		    -OBJECT_RELATIVE_VELOCITY.I,
		    -OBJECT_RELATIVE_VELOCITY.J);

	end;
