--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with INSTRUMENTS, WEAPONS;
separate(AEROPLANE)
    procedure SET_INSTRUMENTS(O  : in OBJECTS.OBJECT_TYPE) is

	AEROPLANE_STATUS : AEROPLANE_STATUS_TYPE
	    renames SUBCLASS_INFO_PKG.SUBCLASS_INFO_TO_ACCESS_STATUS(
			O.SUBCLASS_INFO).all;

	MISSILE_COUNT,
	BULLET_COUNT : NATURAL;

	subtype VALUE_TYPE is INSTRUMENTS.VALUE_TYPE;

	function "/"(LEFT,RIGHT : VALUE_TYPE) return VALUE_TYPE renames
	    INSTRUMENTS."/";

	function ACCEL return VALUE_TYPE is
	begin
	    return VALUE_TYPE(AEROPLANE_STATUS.Gs_FELT);
	end;

	function AoA   return VALUE_TYPE is
	begin
	    return VALUE_TYPE(AEROPLANE_STATUS.AoA);
	end;

	function AoY   return VALUE_TYPE is
	begin
	    return VALUE_TYPE(AEROPLANE_STATUS.AoY);
	end;

	function CLIMB return VALUE_TYPE is
	    METRES_PER_FOOT : constant VALUE_TYPE := 0.3048;
	begin
	    return VALUE_TYPE(O.VELOCITY.K)/METRES_PER_FOOT;
	end;

	function MACH return VALUE_TYPE is
	begin
	    return VALUE_TYPE(AEROPLANE_STATUS.MACH);
	end;

	function FUEL return VALUE_TYPE is
	begin
	    return VALUE_TYPE(AEROPLANE_STATUS.FUEL_MASS)/
		    VALUE_TYPE(AEROPLANE_STATUS.AEROPLANE.MAX_FUEL_MASS);
	end;

	function MISSILES return NATURAL is
	begin
	    return MISSILE_COUNT;
	end;

	function BULLETS return NATURAL is
	begin
	    return 0;
	end;

    begin
	WEAPONS.GET_COUNTS(O, MISSILE_COUNT, BULLET_COUNT);

	INSTRUMENTS.SET(INSTRUMENTS.ACCEL,	ACCEL);
	INSTRUMENTS.SET(INSTRUMENTS.AoA,	AoA);
	INSTRUMENTS.SET(INSTRUMENTS.AoY,	AoY);
	INSTRUMENTS.SET(INSTRUMENTS.CLIMB,	CLIMB);
	INSTRUMENTS.SET(INSTRUMENTS.MACH,	MACH);

	INSTRUMENTS.SET(INSTRUMENTS.FUEL,	FUEL);
	INSTRUMENTS.SET(INSTRUMENTS.MISSILES,   MISSILES);
	INSTRUMENTS.SET(INSTRUMENTS.BULLETS,    BULLETS);
    end;
