--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(AEROPLANE.MOVE_DELTA)
	procedure ROTATE_OBJECT is

	    NEW_I_I, NEW_I_J, NEW_I_K,
	    NEW_J_I, NEW_J_J, NEW_J_K,
	    NEW_K_I, NEW_K_J, NEW_K_K : METRES;

	    OLD_I_I : METRES := O.ORIENTATION.I.I;
	    OLD_I_J : METRES := O.ORIENTATION.I.J;
	    OLD_I_K : METRES := O.ORIENTATION.I.K;

	    OLD_J_I : METRES := O.ORIENTATION.J.I;
	    OLD_J_J : METRES := O.ORIENTATION.J.J;
	    OLD_J_K : METRES := O.ORIENTATION.J.K;

	    OLD_K_I : METRES := O.ORIENTATION.K.I;
	    OLD_K_J : METRES := O.ORIENTATION.K.J;
	    OLD_K_K : METRES := O.ORIENTATION.K.K;

	begin
	    -- PITCH
	    --
	    declare
		use WORLD_PHYSICS;

		A : constant RADIANS
		    := AEROPLANE_STATUS.PITCH_RATE*TIME_DELTA;

		SIN_A : constant SCALE_TYPE := SIN(A);
		COS_A : constant SCALE_TYPE := COS(A);

	    begin
		-- J maps to OBJECT_PHYSICS.POSITION'(0.0, COS_A, SIN_A);
		--
--		NEW_J := O.ORIENTATION.J*COS_A + O.ORIENTATION.K*SIN_A;
		NEW_J_I := OLD_J_I*COS_A + OLD_K_I*SIN_A;
		NEW_J_J := OLD_J_J*COS_A + OLD_K_J*SIN_A;
		NEW_J_K := OLD_J_K*COS_A + OLD_K_K*SIN_A;

		-- K maps to OBJECT_PHYSICS.POSITION'(0.0, -SIN_A, COS_A);
		--
--		NEW_K := O.ORIENTATION.J*(-SIN_A) + O.ORIENTATION.K*COS_A;
		OLD_K_I := OLD_K_I*COS_A - OLD_J_I*SIN_A;
		OLD_K_J := OLD_K_J*COS_A - OLD_J_J*SIN_A;
		OLD_K_K := OLD_K_K*COS_A - OLD_J_K*SIN_A;

		-- Update
		--
--		O.ORIENTATION.J := NEW_J;
		OLD_J_I := NEW_J_I;
		OLD_J_J := NEW_J_J;
		OLD_J_K := NEW_J_K;
--		O.ORIENTATION.K := NEW_K;
--		merged above
	    end;

	    -- ROLL
	    --
	    declare
		use WORLD_PHYSICS;

		A : constant RADIANS
		    := AEROPLANE_STATUS.ROLL_RATE*TIME_DELTA;

		SIN_A : constant SCALE_TYPE := SIN(A);
		COS_A : constant SCALE_TYPE := COS(A);

	    begin
		-- I maps to OBJECT_PHYSICS.POSITION'(COS_A, 0.0, SIN_A);
		--
--		NEW_I := O.ORIENTATION.I*COS_A + O.ORIENTATION.K*SIN_A;
		NEW_I_I := OLD_I_I*COS_A + OLD_K_I*SIN_A;
		NEW_I_J := OLD_I_J*COS_A + OLD_K_J*SIN_A;
		NEW_I_K := OLD_I_K*COS_A + OLD_K_K*SIN_A;

		-- K maps to OBJECT_PHYSICS.POSITION'(-SIN_A, 0.0, COS_A);
		--
--		NEW_K := O.ORIENTATION.I*(-SIN_A) + O.ORIENTATION.K*COS_A;
		O.ORIENTATION.K.I := OLD_K_I*COS_A - OLD_I_I*SIN_A;
		O.ORIENTATION.K.J := OLD_K_J*COS_A - OLD_I_J*SIN_A;
		O.ORIENTATION.K.K := OLD_K_K*COS_A - OLD_I_K*SIN_A;

		-- Update
		--
--		O.ORIENTATION.I := NEW_I;
		OLD_I_I := NEW_I_I;
		OLD_I_J := NEW_I_J;
		OLD_I_K := NEW_I_K;
--		O.ORIENTATION.K := NEW_K;
--		merged above
	    end;

	    -- YAW
	    --
	    declare
		use WORLD_PHYSICS;

		A : constant RADIANS
		    := AEROPLANE_STATUS.YAW_RATE*TIME_DELTA;

		SIN_A : constant SCALE_TYPE := SIN(A);
		COS_A : constant SCALE_TYPE := COS(A);

	    begin
		-- I maps to OBJECT_PHYSICS.POSITION'(COS_A, SIN_A, 0.0);
		--
--		NEW_I := O.ORIENTATION.I*COS_A + O.ORIENTATION.J*SIN_A;
		O.ORIENTATION.I.I := OLD_I_I*COS_A + OLD_J_I*SIN_A;
		O.ORIENTATION.I.J := OLD_I_J*COS_A + OLD_J_J*SIN_A;
		O.ORIENTATION.I.K := OLD_I_K*COS_A + OLD_J_K*SIN_A;

		-- J maps to OBJECT_PHYSICS.POSITION'(-SIN_A, COS_A, 0.0);
		--
--		NEW_J := O.ORIENTATION.I*(-SIN_A) + O.ORIENTATION.J*COS_A;
		O.ORIENTATION.J.I := OLD_J_I*COS_A - OLD_I_I*SIN_A;
		O.ORIENTATION.J.J := OLD_J_J*COS_A - OLD_I_J*SIN_A;
		O.ORIENTATION.J.K := OLD_J_K*COS_A - OLD_I_K*SIN_A;

		-- Update
		--
--		O.ORIENTATION.I := NEW_I;
--		O.ORIENTATION.J := NEW_J;
	    end;
	end;
pragma SUPPRESS_ALL;
