--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************



with CALENDAR, CONTROLS, MOVE_UTILITIES;

with OBJECT_VELOCITY_TO_WORLD_VELOCITY;

with SCALAR_PHYSICS, ANGULAR_PHYSICS,
     SCALE_TYPE_MATH_LIB, TRIG, SCALE_TYPE_TRIG;
use  SCALAR_PHYSICS, ANGULAR_PHYSICS,
     SCALE_TYPE_MATH_LIB, TRIG, SCALE_TYPE_TRIG;

with WORLD_PHYSICS, OBJECT_PHYSICS, PHYSICAL_UNITS, STANDARD_ATMOSPHERE;
use  WORLD_PHYSICS, OBJECT_PHYSICS;

with TEXT_IO, FLOAT_TEXT_IO;
use  TEXT_IO, FLOAT_TEXT_IO;

separate(AEROPLANE)
    procedure MOVE_DELTA(
		    TIME_DELTA		    : SECONDS;
                    CS			    : CONTROLS.CONTROL_SETTING_TYPE;
		    O			    : in out OBJECTS.OBJECT_TYPE;
		    AEROPLANE_STATUS	    : in out AEROPLANE_STATUS_TYPE;
		    MAIN_WING_LIFT_DRAG_INPUTS,
		    BODY_LIFT_DRAG_INPUTS   : in out LIFT_DRAG_CURVE_MANAGER.LIFT_DRAG_INPUTS
		    ) is

	subtype SECONDS is SCALAR_PHYSICS.SECONDS;

	FLAP_CONTROL	: SCALE_TYPE			renames AEROPLANE_STATUS.FLAP_CONTROL;
	PITCH_CONTROL	: SCALE_TYPE			renames AEROPLANE_STATUS.PITCH_CONTROL;
	ROLL_CONTROL	: SCALE_TYPE			renames AEROPLANE_STATUS.ROLL_CONTROL;
	THRUST_CONTROL	: SCALE_TYPE			renames AEROPLANE_STATUS.THRUST_CONTROL;
	YAW_CONTROL	: SCALE_TYPE			renames AEROPLANE_STATUS.YAW_CONTROL;
	DENSITY 	: KILOGRAMS_PER_METRE_CUBED	renames AEROPLANE_STATUS.DENSITY;
	MACH		: STANDARD_ATMOSPHERE.MACH_TYPE renames AEROPLANE_STATUS.MACH;

	WEIRD_ERROR_1, WEIRD_ERROR_2, WEIRD_ERROR_3 : exception;

	A_T : AEROPLANE_TYPE renames AEROPLANE_STATUS.AEROPLANE.all;

	SIN_SWEEP_ANGLE : constant SCALE_TYPE	    := A_T.SIN_SWEEP_ANGLE;
	COS_SWEEP_ANGLE : constant SCALE_TYPE	    := A_T.COS_SWEEP_ANGLE;

	WING_AREA	: constant METRES_SQUARED
			:= A_T.WING_AREA;

	ALTITUDE	: constant METRES
			:= METRES(O.LOCATION.K);

	MASS		: constant KILOGRAMS
			:=  AEROPLANE_STATUS.FUEL_MASS + 
			    A_T.EMPTY_MASS;

	MAIN_WING_LD_MULTIPLIER : constant SCALE_TYPE
			:= (SCALE_TYPE(WING_AREA)*SCALE_TYPE(DENSITY))
			    /(SCALE_TYPE(MASS)*2.0);

	type SURFACE is (LW, RW); -- , B, HT, VT);
	subtype MAIN_WINGS is SURFACE range LW..RW;
	subtype LD_SURFACE is SURFACE range LW..RW;

	V : array(LD_SURFACE) of OBJECT_PHYSICS.VELOCITY;
	L : array(LD_SURFACE) of OBJECT_PHYSICS.ACCELERATION;
	D : array(LD_SURFACE) of OBJECT_PHYSICS.ACCELERATION;

	FINAL_ROLL_RATE 	    : RADIANS_PER_SECOND;

	IN_GROUND_CONTACT	    : BOOLEAN;

	ACCELERATION		    : WORLD_PHYSICS.ACCELERATION;

	OBJECT_RELATIVE_VELOCITY    : OBJECT_PHYSICS.VELOCITY
				      renames AEROPLANE_STATUS.
						OBJECT_RELATIVE_VELOCITY;

	WORLD_RELATIVE_VELOCITY     : WORLD_PHYSICS.VELOCITY
				      renames O.VELOCITY;

	procedure GET_AOA_ETC(
	    V_J 	    : METRES_PER_SECOND;
	    V_K 	    : METRES_PER_SECOND;
	    ANGLE_OF_ATTACK : out RADIANS;
	    SPEED	    : out METRES_PER_SECOND) is separate;


	procedure SET_O_PITCH_YAW_RATE	 is separate;
	procedure SET_SURFACE_VELOCITIES(MAIN_WINGS_ONLY   : BOOLEAN)   is separate;
	procedure SET_SURFACE_LIFT_DRAG (MAIN_WINGS_K_ONLY : BOOLEAN) is separate;
	procedure COMPUTE_ROLL_ETC	 is separate;
	procedure SUM_ACCELERATIONS	 is separate;
	procedure GROUND_CONTACT	 is separate;
	procedure ROTATE_OBJECT 	 is separate;
	procedure DISPLAY_STATE 	 is separate;

    begin

	-- Decide if touching ground
	--
	IN_GROUND_CONTACT := OBJECTS."<="(O.LOCATION.K, A_T.LANDING_HEIGHT);

	-- Predict the PITCH_RATE and the YAW_RATE.
	-- This can be done pretty well independent of the roll rate.
	--
	SET_O_PITCH_YAW_RATE;

	-- Work out roll rate, hence the velocity of each surface, and hence the
	-- lift/drag on each surface
	--
	COMPUTE_ROLL_ETC;

	-- Add up all the accelerations
	--
	SUM_ACCELERATIONS;

	-- Compute the new WORLD_RELATIVE_VELOCITY
	--
	ADD(ACCELERATION*TIME_DELTA, WORLD_RELATIVE_VELOCITY);

	-- Move the object
	--
	MOVE_UTILITIES.ADD_MOVEMENT_TO_LOCATION(
	    WORLD_PHYSICS."*"(WORLD_RELATIVE_VELOCITY,TIME_DELTA),
	    O.LOCATION);

	-- Decide if touching ground
	--
	IN_GROUND_CONTACT := OBJECTS."<="(O.LOCATION.K, A_T.LANDING_HEIGHT);

	-- Process ground contact
	--
	if IN_GROUND_CONTACT then
	    GROUND_CONTACT;
	end if;

	-- New Attitude
	--
	ROTATE_OBJECT;

	-- Display state
	--
	DISPLAY_STATE;

	-- Remember the final roll rate to feed into the next step
	--
	AEROPLANE_STATUS.ROLL_RATE := FINAL_ROLL_RATE;

    end;
