--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

with SCORE;
separate(AEROPLANE.MOVE_DELTA)
	procedure GROUND_CONTACT is
	    GROUND_SPEED : constant METRES_PER_SECOND := LENGTH(O.VELOCITY);
	begin

	    -- Check survived
	    --
	    if  abs(O.ORIENTATION.I.K) >  0.15  -- wings not level
	    or	O.ORIENTATION.J.K  >  0.5	-- heavily nose up
	    or	O.ORIENTATION.J.K  <  0.0	-- too nose down
	    or	O.ORIENTATION.K.K  <  0.0	-- wheels towards sky
	    or	GROUND_SPEED	   > 125.0	-- > 250 mph is too fast
	    then
		-- crash
		--
		SCORE.OTHER_DEATH("Crashed");
		O.DELETE_PENDING := TRUE;

	    end if;

	    -- Force to be at ground level, not below
	    --
	    O.LOCATION.K := A_T.LANDING_HEIGHT;

	    -- Flatten the wings
	    --
	    O.ORIENTATION.I.K := 0.0;

	    -- Don't let it roll
	    --
	    AEROPLANE_STATUS.ROLL_RATE := 0.0;
	    FINAL_ROLL_RATE := 0.0;

	    -- Let the rudder control the yaw
	    --
	    AEROPLANE_STATUS.YAW_RATE :=
		RADIANS_PER_SECOND'(0.1)*(-YAW_CONTROL);

	    -- Drop the nose if too slow, don't let be nose down at all, only
	    -- let it pull up
	    --
	    if GROUND_SPEED < A_T.ROTATE_SPEED
	    or AEROPLANE_STATUS.PITCH_RATE*TIME_DELTA < RADIANS(
							    -O.ORIENTATION.J.K)
	    or O.ORIENTATION.J.K < 0.0
	    then
		O.ORIENTATION.J.K := 0.0;
		AEROPLANE_STATUS.PITCH_RATE := 0.0;
	    end if;

	    -- Make the basis nice after all the above tweaks
	    --
	    FIX_BASIS(O);

	    -- Stop sinking
	    --
	    if O.VELOCITY.K < 0.0 then
		O.VELOCITY.K := 0.0;
	    end if;

	    -- Set the velocity relative to the airframe
	    --
	    SET_O_VELOCITY(O, AEROPLANE_STATUS);

	    -- Get rid of side-slip
	    --
	    OBJECT_RELATIVE_VELOCITY.I := 0.0;

	    -- Cope with over-braking, second line of test is needed to
	    -- stop plane "bouncing" when landing nose-high.
	    --
	    if	OBJECT_RELATIVE_VELOCITY.J < 0.0
	    and O.ORIENTATION.J.K = 0.0
	    then
		OBJECT_RELATIVE_VELOCITY.J := 0.0;
	    end if;

	    -- Reflect the changes into the WRV
	    --
	    OBJECT_VELOCITY_TO_WORLD_VELOCITY(
		O.ORIENTATION,
		OBJECT_RELATIVE_VELOCITY,
		O.VELOCITY);

	end;
