--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(AEROPLANE.MOVE_DELTA)
	procedure GET_AOA_ETC(
	    V_J 	    : METRES_PER_SECOND;
	    V_K 	    : METRES_PER_SECOND;
	    ANGLE_OF_ATTACK : out RADIANS;
	    SPEED	    : out METRES_PER_SECOND) is

	    J : constant SCALE_TYPE := SCALE_TYPE(V_J);
	    K : constant SCALE_TYPE := SCALE_TYPE(V_K);
	    S : SCALE_TYPE := SQRT(J*J+K*K);

	begin

	    SPEED := METRES_PER_SECOND(S);

	    ANGLE_OF_ATTACK := 0.0;
	    if S > (10.0**(-SCALE_TYPE'digits/2)) then
		S := (-1.0)/S;
		ANGLE_OF_ATTACK := -SCALE_TYPE_TRIG.ASIN_ACOS(K*S, J*S);
	    end if;

	end;
pragma SUPPRESS_ALL;
