--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    SCALAR_PHYSICS, STANDARD_ATMOSPHERE;
use
    SCALAR_PHYSICS, STANDARD_ATMOSPHERE;
pragma ELABORATE(
    SCALAR_PHYSICS, STANDARD_ATMOSPHERE);

separate(AEROPLANE)
    procedure ENGINE_THRUST_V_MACH_AND_ALT(
	AEROPLANE_STATUS    : AEROPLANE_STATUS_TYPE;
	ALTITUDE	    : METRES;
	TIME_DELTA	    : SECONDS;
	AFTERBURNER_ON	    : BOOLEAN;

	THRUST		    : out NEWTONS;
	BURNT		    : out KILOGRAMS) is

	A_T : AEROPLANE_TYPE renames AEROPLANE_STATUS.AEROPLANE.all;

	CONSUMPTION : KILOGRAMS_PER_SECOND;
	ENGINE_MODE : ENGINE_MODE_TYPE;

    begin
	ENGINE_MODE := MILITARY;
	if AFTERBURNER_ON then ENGINE_MODE := MAXIMUM; end if;

	GET_ENGINE_INFO(
	    A_T.ENGINE,
	    AEROPLANE_STATUS.THRUST_CONTROL,
	    ENGINE_MODE,
	    AEROPLANE_STATUS.MACH,
	    AEROPLANE_STATUS.DENSITY,

	    THRUST,
	    CONSUMPTION);

	BURNT := CONSUMPTION * TIME_DELTA;
    end;
