--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with AEROPLANE_DEBUGGING;
separate(AEROPLANE.MOVE_DELTA)
	procedure DISPLAY_STATE is
	    use CALENDAR;

	    procedure P(S : STRING; F : FLOAT) is
	    begin
		PUT(S);
		PUT(F, AFT=>2);
	    end;

	    procedure P(S : STRING; POSITION : WORLD_PHYSICS.POSITION) is
	    begin
		NEW_LINE;
		P(S&".I = ", FLOAT(POSITION.I)); PUT(" ");
		P(S&".J = ", FLOAT(POSITION.J)); PUT(" ");
		P(S&".K = ", FLOAT(POSITION.K));
	    end;

	    procedure P(S : STRING; VELOCITY : OBJECT_PHYSICS.VELOCITY) is
	    begin
		NEW_LINE;
		P(S&".I = ", FLOAT(VELOCITY.I)); PUT(" ");
		P(S&".J = ", FLOAT(VELOCITY.J)); PUT(" ");
		P(S&".K = ", FLOAT(VELOCITY.K));
	    end;

	    procedure P(S : STRING; VELOCITY : WORLD_PHYSICS.VELOCITY) is
	    begin
		NEW_LINE;
		P(S&".I = ", FLOAT(VELOCITY.I)); PUT(" ");
		P(S&".J = ", FLOAT(VELOCITY.J)); PUT(" ");
		P(S&".K = ", FLOAT(VELOCITY.K));
	    end;

	    procedure P(S : STRING; ACC : OBJECT_PHYSICS.ACCELERATION) is
	    begin
		NEW_LINE;
		P(S&".I = ", FLOAT(ACC.I)); PUT(" ");
		P(S&".J = ", FLOAT(ACC.J)); PUT(" ");
		P(S&".K = ", FLOAT(ACC.K));
	    end;

	    procedure P(S : STRING; ACC : WORLD_PHYSICS.ACCELERATION) is
	    begin
		NEW_LINE;
		P(S&".I = ", FLOAT(ACC.I)); PUT(" ");
		P(S&".J = ", FLOAT(ACC.J)); PUT(" ");
		P(S&".K = ", FLOAT(ACC.K));
	    end;

	begin

	    if AEROPLANE_DEBUGGING.DISPLAY_STATE_ENABLED 
	    and CS.QUIT_PRESSED
	    then

		NEW_LINE(2);

		P("ALT    ", FLOAT(O.LOCATION.K));
		P("MACH   ", FLOAT(MACH));
		P("LD mult", FLOAT(MAIN_WING_LD_MULTIPLIER));
		P("Density", FLOAT(DENSITY));
		P("Thrust ", FLOAT(AEROPLANE_STATUS.THRUST));	    NEW_LINE;

		P("CL_alpL", FLOAT(AEROPLANE_STATUS.CL_ALPHA_LEFT));
		P("CL_alpR", FLOAT(AEROPLANE_STATUS.CL_ALPHA_RIGHT));
		P("CD_L",    FLOAT(AEROPLANE_STATUS.CD_CL_LEFT.CD));
		P("CL_L",    FLOAT(AEROPLANE_STATUS.CD_CL_LEFT.CL));
		P("CD_R",    FLOAT(AEROPLANE_STATUS.CD_CL_RIGHT.CD));
		P("CL_R",    FLOAT(AEROPLANE_STATUS.CD_CL_RIGHT.CL));NEW_LINE;

		P(" I",      O.ORIENTATION.I);
		P(" J",      O.ORIENTATION.J);
		P(" K",      O.ORIENTATION.K);
		NEW_LINE;

		declare
		    J : constant SCALE_TYPE := SCALE_TYPE(OBJECT_RELATIVE_VELOCITY.J);
		    K : constant SCALE_TYPE := SCALE_TYPE(OBJECT_RELATIVE_VELOCITY.K);
		    S : constant SCALE_TYPE := SQRT(J*J+K*K);
		begin
		    if S > 0.01 then
			P("AoA    ",
			    FLOAT(-SCALE_TYPE_TRIG.ASIN_ACOS(K/S, J/S))*
			    (360.0/6.283)
			  );
			PUT_LINE(" degrees");
		    end if;
		end;

		P(" Spd = ", FLOAT(LENGTH(O.VELOCITY)));
		NEW_LINE;

		P(" Rll = ", FLOAT(AEROPLANE_STATUS.ROLL_RATE));
		P(" Pit = ", FLOAT(AEROPLANE_STATUS.PITCH_RATE));
		P(" Yaw = ", FLOAT(AEROPLANE_STATUS.YAW_RATE));
		NEW_LINE;

		P(" S",      OBJECT_RELATIVE_VELOCITY);
		P(" A",      ACCELERATION);
		for I in L'range loop
		    NEW_LINE;
		    PUT(SURFACE'IMAGE(I));
		    P(" L", L(I));
		    P(" D", D(I));
		end loop;
		NEW_LINE;
	    end if;
	end;
