--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(AEROPLANE.MOVE_DELTA)
	procedure COMPUTE_ROLL_ETC is
	    ORR : RADIANS_PER_SECOND renames AEROPLANE_STATUS.ROLL_RATE;

	    RR_1	: RADIANS_PER_SECOND;
	    DELTA_RR_1	: RADIANS_PER_SECOND;

	    RR_2	: RADIANS_PER_SECOND;
	    DELTA_RR_2	: RADIANS_PER_SECOND;

	    MID_WING	: BOOLEAN := (A_T.SIN_PLACEMENT_ANGLE=0.0);

	    function DELTA_RR return RADIANS_PER_SECOND is
		ACC : METRES_PER_SECOND_SQUARED;
	    begin
		ACC := L(RW).K+D(RW).K-L(LW).K-D(LW).K;

		if not MID_WING then
		    ACC :=
			(ACC)*A_T.COS_PLACEMENT_ANGLE -
			(L(RW).I+D(RW).I+L(LW).I+D(LW).I)
			     *A_T.SIN_PLACEMENT_ANGLE;
		end if;

		return
		    RADIANS_PER_SECOND(
			METRES_PER_SECOND'(ACC*TIME_DELTA)
			*A_T.ANGULAR_ROLL_FACTOR);
	    end;

	begin

	    -- Assume previous rate
	    --
	    SET_SURFACE_VELOCITIES(TRUE);
	    SET_SURFACE_LIFT_DRAG(MID_WING);

	    -- Work out how much torque this would be, and hence how much
	    -- could change in this time interval
	    -- 
	    RR_1	:= ORR;
	    DELTA_RR_1  := DELTA_RR;

	    -- Try that ROLL_RATE
	    --
	    ORR := ORR+DELTA_RR_1;
	    SET_SURFACE_VELOCITIES(TRUE);
	    SET_SURFACE_LIFT_DRAG(MID_WING);

	    RR_2	:= ORR;
	    DELTA_RR_2  := DELTA_RR;

	    -- Work out an average and final RR based on these possibilities
	    --
	    if (DELTA_RR_1 > 0.0) = (DELTA_RR_2 > 0.0) then
		-- both agree on which way to go.
		--
		FINAL_ROLL_RATE := RR_2;
	    else
		-- disagree on which way to go.
		-- use point where DELTA_RR would be 0.0 as both
		-- the FINAL_ROLL_RATE
		--
		declare
		    F1 : SCALE_TYPE := SCALE_TYPE(DELTA_RR_2)/
					SCALE_TYPE(DELTA_RR_2-DELTA_RR_1);
		    F2 : SCALE_TYPE := 1.0-F1;
		begin
		    FINAL_ROLL_RATE := RR_1*F1 + RR_2*F2;
		end;
	    end if;

	    -- use average of RR_1 and the final roll rate to get the best
	    -- estimate for the surfaces for this period
	    --
	    ORR := (RR_1+FINAL_ROLL_RATE)/2.0;

	    -- Final estimates
	    --
	    SET_SURFACE_VELOCITIES(FALSE);
	    SET_SURFACE_LIFT_DRAG(FALSE);
	    
	end;
