/* Ygl: Run 2d-GL programs with standard X11 routines. (C) Fred Hucht 1993/94 */

#include "header.h"

#define VERSION "2.4"

static const char *WhatString[2]= {
  "@(#)Ygl V" VERSION " by Fred Hucht (C) 1993/94",
  "@(#)EMail: fred@thp.Uni-Duisburg.DE"
};

void singlebuffer() {
  W->draw = W->win;
}

#ifdef MULTIBUF
#define YglUpdateAction MultibufferUpdateActionBackground
#define YglUpdateHint   MultibufferUpdateHintIntermittent

static int HasMBuf = True;

void swapbuffers() {
  if(!HasMBuf) {
    XFlush(D);
    return;
  }
  I;
  if(W->abuf == -1) {
    fprintf(stderr, "Ygl: swapbuffers: doublebuffering not initialized for window %d.\n", winget());
    return;
  }
  W->draw = W->mbuf[W->abuf];
  W->abuf = 1 - W->abuf;
  XmbufDisplayBuffers(D, 1, W->mbuf + W->abuf, 0, 0);
  F;
}

void doublebuffer() {
  I;
  if(HasMBuf) {
    if(2 != XmbufCreateBuffers(D, W->win, 2, YglUpdateAction, YglUpdateHint, W->mbuf)) {
      fprintf(stderr, "Ygl: doublebuffer: unable to create 2 buffers.\n");
      HasMBuf = False;
    } else {
      W->abuf = 0;
      W->draw = W->mbuf[1 - W->abuf]; /* draw to backbuffer */
    }
  }
}
#else

void swapbuffers() {
  XFlush(D);
}

void doublebuffer() {
  fprintf(stderr, "Ygl: doublebuffer: Ygl is not configured to use doublebuffering.\n");
}

#endif /*MULTIBUF*/

/* Fonts */
static struct {
  XFontStruct *fs;
  Int32   id;
} YglFonts[YGL_MAXFONTS];

static short YglLastFont = -1;
static XFontStruct *YglFontStruct;

void loadXfont(Int32 id, Char8 *name) {
  XFontStruct *fs;
  I;
  if(NULL == (fs = XLoadQueryFont(D, name))) {
    fprintf(stderr, "Ygl: loadXfont: can't find font '%s'\n", name);
    return;
  }
  YglLastFont++;
  YglFonts[YglLastFont].fs = fs;
  YglFonts[YglLastFont].id = id;
#ifdef DEBUG
  fprintf(stderr, "loadXfont: font = 0x%x, id = %d\n", fs, id);
#endif
}

void font(Int16 id) {
  short i = YglLastFont;
  I;
  while( i > 0 && YglFonts[i].id != id ) i--;
  YglFontStruct = YglFonts[i].fs;
  if(W->rgb) {
    XSetFont(D, W->gc, YglFontStruct->fid);
  } else {
#ifdef GCLIST
    XSetFont(D, W->chargc, YglFontStruct->fid);
#else
    XSetFont(D, W->gc, YglFontStruct->fid);
#endif
  }
/*  if(YglFontStruct != NULL) XFreeFont(D,YglFontStruct);
  YglFontStruct = XQueryFont(D, YglFonts[i].font);
  */
}

Int32 getheight()    { return(YglFontStruct->ascent + YglFontStruct->descent);}
Int32 getdescender() { return(                        YglFontStruct->descent);}

Int32 strwidth(Char8 *string) {
  I;
  return(XTextWidth(YglFontStruct, string, strlen(string)));
}

void gflush() {
  I;
  XFlush(D);
}

Display *getXdpy() {
  return(D);
}

Window *getXwid() {
  return((Window*)(W->win));
}

GC *getXgc() {
  return((GC*)(W->gc));
}

void getsize(Int32 *x, Int32 *y) { 
  XWindowAttributes a;
  I;
  XGetWindowAttributes(D, W->win, &a);
  *x = a.width;
  *y = a.height;
}

void getorigin(Int32 *x, Int32 *y) { 
  XWindowAttributes a;
  Window junkwin;
  int rx, ry;
  I;
  XGetWindowAttributes(D, W->win, &a);
  XTranslateCoordinates (D, W->win, a.root, -a.border_width, -a.border_width, &rx, &ry, &junkwin);

#ifdef DEBUG
  fprintf(stderr, "getorigin: %d %d\n", rx, ry);
#endif

  *x = rx;
  *y = YglScreenHeight - (a.height + ry);
}

Int32 getvaluator(Device dev) {
  Window junkwin;
  int rx, ry, cx, cy;
  Uint mask;
  I;
  XQueryPointer(D, W->win, &junkwin, &junkwin, &rx, &ry, &cx, &cy, &mask);
#ifdef DEBUG
  fprintf(stderr, "getvaluator: root = (%d,%d), child = (%d,%d) mask=0x%x\n", rx, ry, cx, cy, mask);
#endif
  switch(dev) {
  case MOUSEX : return(rx); break;
  case MOUSEY : return(YglScreenHeight - ry - 1); break;
  default     : fprintf(stderr, "Ygl: getvaluator: Unknown device: %d\n", dev); return -1; break;
  }
}

Int32 getbutton(Device dev) {
  Window junkwin;
  int junk;
  Uint mask;
  I;
  XQueryPointer(D, W->win, &junkwin, &junkwin, &junk, &junk, &junk, &junk, &mask);
#ifdef DEBUG
  fprintf(stderr, "getbutton: mask = 0x%x\n", mask);
#endif
  switch(dev) {
  case   LEFTMOUSE : return(0 != (mask & Button1Mask)); break;
  case MIDDLEMOUSE : return(0 != (mask & Button2Mask)); break;
  case  RIGHTMOUSE : return(0 != (mask & Button3Mask)); break;
  default          : fprintf(stderr, "Ygl: getbutton: Unknown device: %d\n", dev); return -1; break;
  }
}

Int32 gversion(Char8 *v) { 
  static char *YglVersion = "Ygl:X11-" VERSION;
  int i = 0;
  while('\0' != (*(v+i) = *(YglVersion+i))) i++;
  return(0);
}

#ifdef ORTHO
void ortho2(Coord x1, Coord x2, Coord y1, Coord y2) {
  W->xo = x1;
  W->yo = y1;
  W->xd = x2 - x1;
  W->yd = y2 - y1;
  W->xf = (double)W->xm / W->xd;
  W->yf = (double)W->ym / W->yd;
}
#endif 

void reshapeviewport() {
  Int32 x, y;
  getsize(&x, &y);
  W->xm = x; W->ym = y;
  W->xf = (double)W->xm / W->xd;  /* Used in scaled lib */
  W->yf = (double)W->ym / W->yd;  /* Used in scaled lib */
}

void winmove(Int32 x, Int32 y) {
  Int32 xs, ys;
  getsize(&xs, &ys);
  XMoveWindow(D, W->win, x, YglScreenHeight - y - ys);
}

void winposition(Int32 x1, Int32 x2, Int32 y1, Int32 y2) {
  I;
  XMoveResizeWindow(D, W->win, x1, YglScreenHeight - y2, x2-x1, y2-y1);
}

#ifdef COVERSLEEP

#if defined (__linux) /* Any others? */
# define USLEEP_RETURNS_VOID
#endif

#ifdef USLEEP_RETURNS_VOID
void
#else
int
#endif

usleep(unsigned long Useconds) {
  struct timeval tmout;
  if(D != NULL) XFlush(D);
  tmout.tv_usec = Useconds % 1000000;
  tmout.tv_sec  = Useconds / 1000000;
  (void) select(0, NULL, NULL, NULL, &tmout);
#ifdef USLEEP_RETURNS_VOID
  return;
#else
  return (0);
#endif
}

unsigned int sleep(unsigned int seconds) {
  struct timeval tmout;
  if(D != NULL) XFlush(D);
  tmout.tv_usec = 0;
  tmout.tv_sec  = seconds;
  (void) select(0, NULL, NULL, NULL, &tmout);
  return (0);
}
#endif
