/* lines.c by Fred Hucht (C) 1993.
   Example program to compare performance */

#include <gl/gl.h>
#include <gl/device.h>
#include <stdio.h>

#define SIZE 512
#define STEP 4

int n;

void drawit() {
  int i, j, col;
  color(WHITE); clear();
  col = 0;
  for(i=0; i<SIZE; i+=STEP) {
    color(col);
    /* The next line is a loop for performance comparsion. */
    for(j=0; j<SIZE; j+=STEP) rectfi(i, j, i+STEP-1, j+STEP-1);
    /* It's much faster to use this... */
    /* rectfi(i,0,i+STEP-1,SIZE-1); */
    col = (col+1) % n;
  }
  color(WHITE);
  rectfi(5, 5, 450, 30);
  
  color(BLACK);
  font(4711);
  cmov2i(10, 10);
  charstr("This is font Times 14. Press ESC to exit...");
}

int main() {
  char buf1[20], buf2[80];
  Int32 win;

  minsize(SIZE, SIZE);
  gversion(buf1);
  sprintf(buf2, "Lines drawn with %s",buf1);
  win = winopen(buf2);
  qdevice(KEYBD);
  qdevice(WINCLOSE);
  qdevice(REDRAW);
  qenter(REDRAW, win);
  
  loadXfont(4711, "timr14");
  
  n = 1 << getplanes(); /* Number of colors */
  n = (n<8) ? n : 8;    /* Number of predefined colors */

  while (1) {
    Device dev;
    short val;
    switch(dev = qread(&val)) {
    case REDRAW:
      reshapeviewport();
      drawit();
      break;
    case KEYBD:
      if(val != '\033') break;
    case WINCLOSE:
      gexit();
      exit(0);
      break;
    }
  }
}
