/* coltest.c by Fred Hucht (C) 1993.
   Example for color animation with private colormap */

#include <gl/gl.h>
#include <gl/device.h>
#define _XOPEN_SOURCE /* to get M_PI from math.h in AIX */
#include <math.h>

int main() {
  int i=0;
  double phi;
  minsize(400,400);
  
  putenv("YGL_PRIVATECOLORMAP=1");

  /* setenv("YGL_PRIVATECOLORMAP","1",1); /* use this one under BSD unixes */

  puts("Using private colormap");
  
  winopen("Coltest, <ESC> to quit");

  qdevice(KEYBD);
  qdevice(REDRAW);
  qdevice(WINCLOSE);
  unqdevice(INPUTCHANGE);

  while(1) switch(qtest()) {
  case 0: /* No event received */
    phi = 2.0 * M_PI * (double)(++i) / 64.0;
    mapcolor(12,
	     127.5 * (1.0+cos(phi           )),
	     127.5 * (1.0+cos(phi-2./3.*M_PI)),
	     127.5 * (1.0+cos(phi-4./3.*M_PI))
	     );
    mapcolor(13,
	     127.5 * (1.0+cos(phi-(        0.5)*M_PI)),
	     127.5 * (1.0+cos(phi-(2./3. + 0.5)*M_PI)),
	     127.5 * (1.0+cos(phi-(4./3. + 0.5)*M_PI))
	     );
    mapcolor(14,
	     127.5 * (1.0+cos(phi-(        1.0)*M_PI)),
	     127.5 * (1.0+cos(phi-(2./3. + 1.0)*M_PI)),
	     127.5 * (1.0+cos(phi-(4./3. + 1.0)*M_PI))
	     );
    mapcolor(15,
	     127.5 * (1.0+cos(phi-(        1.5)*M_PI)),
	     127.5 * (1.0+cos(phi-(2./3. + 1.5)*M_PI)),
	     127.5 * (1.0+cos(phi-(4./3. + 1.5)*M_PI))
	     );
    usleep(100000);
    break;
  case REDRAW:
    qreset();
    reshapeviewport();
    color(WHITE); clear();
    color(12); circfi(100,100,80);
    color(13); circfi(100,300,80);
    color(14); circfi(300,300,80);
    color(15); circfi(300,100,80);
    break;
  case KEYBD:
    {
      Int16 val;
      qread(&val);
      if (val != '\033') break;
    }
  case WINCLOSE:
    gexit();
    exit(0);
    break;
  default:
    qreset();
    break;
  }
}
