/*
** Very Simple Xew Widget Demonstration Program
** (Using porthhole and panner, logic copied from editres program if
**  X11R5 is defined, and viewport otherwise)
*/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Paned.h>
#if X11R5
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#else
#include <X11/Xaw/Viewport.h>
#endif
#include <X11/Xew/Basic.h>
#include <X11/Xew/Raster.h>
#include <X11/Xew/Text.h>
#include <X11/Xew/Audio.h>
#include <X11/Xew/Video.h>
#include <X11/Xew/Support.h>

#include "ui_tools.h"

static Widget lookingat = None;

UI_ElementDef image_list[] =
    {
	UI_PANE("ColorMode"),
	UI_TOGGLE("mono",	XeColorMode_MONO),
	UI_RADIO("gray",	XeColorMode_GRAY),
	UI_RADIO("color", 	XeColorMode_COLOR),
	UI_LOAD(XtNcolorMode),
	UI_INPUT("max colors:"),
	UI_LOAD(XtNmaxColors),
	UI_LABEL("Dither"),
	UI_TOGGLE("none",	XeDither_NONE),
	UI_RADIO("fs4",		XeDither_FS4),
	UI_LOAD(XtNdither),
	UI_LABEL("ColorQuantize"),
	UI_TOGGLE("fast",	XeColorQuantize_FAST),
	UI_RADIO("heckbert",	XeColorQuantize_HECKBERT),
	UI_RADIO("ppmquant",	XeColorQuantize_PPMQUANT),
	UI_RADIO("jpeg",	XeColorQuantize_JPEG),
	UI_LOAD(XtNcolorQuantize),

	UI_PANE("Colormap use"),
	UI_TOGGLE("shared",	XeColormapUse_SHARED),
	UI_RADIO("sharedown",	XeColormapUse_SHAREDOWN),
	UI_RADIO("optional",	XeColormapUse_OPTIONAL),
	UI_RADIO("private",	XeColormapUse_PRIVATE),
	UI_LOAD(XtNcolormapUse),
	UI_LABEL("Miscellanous"),
	UI_TOGGLE("Use MIT-SHM",True),
	UI_LOAD(XtNuseShm),
	UI_TOGGLE("Install colormap", True),
	UI_LOAD(XtNcolormapInstall),
	UI_TOGGLE("Resize", True),
	UI_LOAD(XtNresize),
	UI_INPUT("foreground: "),
	UI_LOAD(XtNforeground),
	UI_INPUT("background: "),
	UI_LOAD(XtNbackground),

	UI_PANE("Geometry"),
	UI_INPUT("Width :"),
	UI_LOAD(XtNwidth),
	UI_INPUT("Height:"),
	UI_LOAD(XtNheight),
	UI_LABEL("Scaling"),
	UI_TOGGLE("none",	XeScaling_NONE),
	UI_RADIO("width",	XeScaling_WIDTH),
	UI_RADIO("height",	XeScaling_HEIGHT),
	UI_RADIO("maxaspect",	XeScaling_MAXASPECT),
	UI_RADIO("fitarea",	XeScaling_FITAREA),
	UI_LOAD(XtNscaling),
	UI_LABEL("Rotation"),
	UI_TOGGLE("  0",	0),
	UI_RADIO( " 90",	90),
	UI_RADIO( "180",	180),
	UI_RADIO( "270",	270),
	UI_LOAD(XtNrotation),
	UI_TOGGLE("mirror",	True),
	UI_LOAD(XtNmirrorImage),
	UI_END(),
    };

UI_PanelDef image_resources = 
    {
	"resources",
	image_list,
	UI_AcceptPanel,
	(XtPointer)&image_resources,
    };

/*
** Notify_MENU
**	Popup a menu panel associated with the widget
*/
static void Notify_MENU(w, data)
Widget w;
XtPointer data;
    {
	image_resources.target = w;
	UI_SetToggles(&image_resources);
	UI_PopupPanel(w, (XtPointer)&image_resources, data);
    }

/*
** Sample Notify skeleton..
*/
static void Notify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeNotifyCallbackData *notify = (XeNotifyCallbackData *)call_data;
	int i;

	switch (notify->reason)
	    {
	    case XeCR_NOTIFY:
		/* Quickhack: just assume it's a button event! */
		printf("Notify(");
		for (i = 0; i < notify->num_params; i++)
		    {
			if (strcmp("MENU", notify->params[i]) == 0)
				Notify_MENU(w, client_data);
			else
				printf("%s%s", i==0?"":",", notify->params[i]);
		    }
		printf(") at (%d,%d)\n",
		       (int)notify->event->xbutton.x,
		       (int)notify->event->xbutton.y);
		break;
	    default:
		printf("UNKNOWN: XeRC=%d\n");
		break;
	    }
    }

/*
** Sample Expose callback
*/
static void Redisplay(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeExposeCallbackData *expose = (XeExposeCallbackData *)call_data;

	if (expose && expose->event)
	    {
		printf("Expose()\n"); /* Do nothing, this is just a demo */
	    }
    }

#if X11R5

void PortholeCallback(w, panner_ptr, report_ptr)
Widget w;
XtPointer panner_ptr, report_ptr;
    {
	Arg args[10];
	Cardinal n = 0;
	XawPannerReport *report = (XawPannerReport *)report_ptr;
	Widget panner = (Widget)panner_ptr;

	XtSetArg(args[n], XtNsliderX, report->slider_x); n++;
	XtSetArg(args[n], XtNsliderY, report->slider_y); n++;
	if (report->changed != (XawPRSliderX | XawPRSliderY))
	    {
		XtSetArg(args[n], XtNsliderWidth, report->slider_width); n++;
		XtSetArg(args[n], XtNsliderHeight, report->slider_height); n++;
		XtSetArg(args[n], XtNcanvasWidth, report->canvas_width); n++;
		XtSetArg(args[n], XtNcanvasHeight, report->canvas_height); n++;
	    }
	XtSetValues (panner, args, n);
    }

void PannerCallback(w, closure, report_ptr)
Widget w;
XtPointer closure, report_ptr;
    {
	Arg args[2];
	XawPannerReport *report = (XawPannerReport *)report_ptr;

	if (lookingat == None) 
		return;
	XtSetArg (args[0], XtNx, -report->slider_x);
	XtSetArg (args[1], XtNy, -report->slider_y);
	XtSetValues(lookingat, args, 2);
    }

#endif

static void AddContent();

static char *source_file;

static void  PopdownFileDialog(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	String filename;
	Widget dialog = XtParent(w);

	filename = XawDialogGetValueString(dialog);
	if (source_file)
		free((void *)source_file);
	source_file = strdup(filename);
	AddContent(lookingat, source_file);
	UI_Popdown(w, client_data, call_data);
    }

static UI_DialogDef popup_dialog_loadfile =
    {
	"File name: ",
	"",
	PopdownFileDialog,
	(XtPointer)0,
    };

static UI_MenuItemDef file_menu_items[] =
    {
	{"Load File", UI_PopupDialog, (XtPointer)&popup_dialog_loadfile,},
	{"Quit", UI_Quit, NULL},
	{NULL},
    };

static UI_MenuDef file_menu =
    {
	"File",
	file_menu_items,
    };

/*
** AddContent
*/
static void AddContent(parent, name)
Widget parent;
char *name;
    {
	XeContentFormat type;
	Arg args[10];
	int n, i;
	Widget widget;

	type = XeFindContentFormat(name);
	n = 0;
	XtSetArg(args[n], XtNcontentFile, name); ++n;
	XtSetArg(args[n], XtNcontentFormat, type); ++n;
	switch (XeFindContentClass(type))
	    {
	    default:
		printf("Assuming Text content type\n");
		/*
		** Request proportional spacing, because we are not
		** specifying the lineSpacing.
		*/
		XtSetArg(args[n], XtNproportional, True); ++n;
		widget = XtCreateManagedWidget
			(name,xeTextWidgetClass,parent,args,n);
		break;
	    case XeContentClass_AUDIO:
		widget = XtCreateManagedWidget
			(name,xeAudioWidgetClass,parent,args,n);
		break;
	    case XeContentClass_VIDEO:
		widget = XtCreateManagedWidget
			(name,xeVideoWidgetClass,parent,args,n);
		break;
	    case XeContentClass_RASTER:
		widget = XtCreateManagedWidget
			(name,xeRasterWidgetClass, parent,args,n);
		break;
	    }
	XtAddCallback(widget,XtNnotifyCallback,Notify,(XtPointer)NULL);
	XtAddCallback(widget,XtNexposeCallback,Redisplay,(XtPointer)NULL);
    }

#include "fallback.c"

main(argc, argv)
int argc; char *argv[];
    {
	XtAppContext demo_application;
	Widget root_widget, porthole, panner, pane, box, button;
	Arg args[10];
	int n, i;

	root_widget = XtAppInitialize
		(&demo_application, "XewViewer", NULL,0, &argc, argv,
		 fallback_resources, NULL, 0);
	UI_Initialize(demo_application);
	n = 0;
	pane = XtCreateManagedWidget
		("pane", panedWidgetClass, root_widget, args, n);
	n = 0;
	box = XtCreateManagedWidget
		("box", boxWidgetClass, pane, args, n);
	UI_CreateMenu(box, &file_menu);

#if X11R5
	/*
	** Use Porthole/Panner if X11R5 available
	*/
	n = 0;
	panner = XtCreateManagedWidget
		("panner", pannerWidgetClass, box, args, n);
	n = 0;
	porthole = XtCreateManagedWidget
		("DemoPort", portholeWidgetClass, pane, args, n);
	XtAddCallback(porthole, XtNreportCallback,
		      PortholeCallback, (XtPointer)panner);
	XtAddCallback(panner, XtNreportCallback,
		      PannerCallback, (XtPointer)porthole);
#else
	/*
	** Use plain old viewport if X11R4
	*/
	n = 0;
	XtSetArg(args[n], XtNallowHoriz, True); ++n;
	XtSetArg(args[n], XtNallowVert, True); ++n;
	XtSetArg(args[n], XtNshowGrip, False); ++n;
	porthole = XtCreateManagedWidget("DemoView", viewportWidgetClass,
				     pane,args, n);
#endif
	if (argc < 2)
	    {
		printf("usage: viewer files(s)\n");
		exit(0);
	    }
	n = 0;
	lookingat = XtCreateManagedWidget
		("DemoView", boxWidgetClass, porthole, args, n);
	for (i = 1; i  < argc; i++)
		AddContent(lookingat, argv[i]);
	XtRealizeWidget(root_widget);
	XtAppMainLoop(demo_application);
	return 0;
    }

