/*
** Very Simple EuroBridge Video Widget Demonstration Program
*/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Command.h>
#include <X11/Xew/Basic.h>
#include <X11/Xew/Animation.h>
#include <X11/Xew/Video.h>


/*
** This callback will set the value of the "play" resource of the
** video widget according to the state of the toggle:
**
**	True	-> XePlay_FORWARD	continue/start playing
**	False	-> XePlay_FREEZE	stop playing
*/
static void Play(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Arg args[1];
	Widget video = (Widget)client_data;

	XtSetArg(args[0], XtNstate, False);
	XtGetValues(w, args, 1);
	if ((int)args[0].value)
		XtSetArg(args[0], XtNplay, XePlay_FORWARD);
	else
		XtSetArg(args[0], XtNplay, XePlay_FREEZE);
	XtSetValues(video, args, 1);
    }

/*
** This callback will set the recource "contentLoaded" to False,
** which causes the video widget to restart reading of the input
** stream.
*/
static void Again(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Arg args[1];
	Widget video = (Widget)client_data;

	XtSetArg(args[0], XtNcontentLoaded, False);
	XtSetValues(video, args, 1);
    }

#include "fallback.c"

main(argc, argv)
int argc; char *argv[];
    {
	XtAppContext demo_application;
	Widget root_widget, pane, box, play, again, video, view;
	Arg args[10];
	int n, i;

	root_widget = XtAppInitialize(&demo_application, "XewVideo",
				      NULL,0, &argc, argv,
				      fallback_resources,
				      NULL, 0);
	n = 0;
	pane = XtCreateManagedWidget("DemoView", panedWidgetClass,
				     root_widget,args, n);
	i = 1;
	do
	    {
		n = 0;
		box = XtCreateManagedWidget
			("DemoBox", boxWidgetClass, pane, args, n);
		n = 0;
		XtSetArg(args[n], XtNlabel, "PLAY"); ++n;
		play = XtCreateManagedWidget
			("DemoPlay", toggleWidgetClass, box, args, n);
		n = 0;
		XtSetArg(args[n], XtNlabel, "AGAIN"); ++n;
		again = XtCreateManagedWidget
			("DemoCommand",  commandWidgetClass, box, args, n);
		n = 0;
		if (i < argc)
		    {
			XtSetArg(args[n], XtNcontentFile, argv[i]); ++n;
		    }
		else
		    {
			XtSetArg(args[n], XtNcontentStream, stdin); ++n;
		    }
		XtSetArg(args[n], XtNcontentFormat, XeContentFormat_MPEG); ++n;
		XtSetArg(args[n], XtNresize, True); ++n;
		XtSetArg(args[n], XtNplay, XePlay_FREEZE); ++n;
		video = XtCreateManagedWidget("DemoVideo", xeVideoWidgetClass,
					      pane, args, n);
		XtAddCallback(play, XtNcallback, Play, (XtPointer)video);
		XtAddCallback(again, XtNcallback, Again, (XtPointer)video);
	    }
	while (++i < argc);
	XtRealizeWidget(root_widget);
	XtAppMainLoop(demo_application);
	return 0;
    }

