/*
** A demo program for TextEd widget
**
** WARNING!
**	This is not any real "editor". The user interface is just a
**	jumbled collection of buttons and menus which access the
**	TextEd features individually at low level.
*/
#include <stdio.h>
#if SYSV_INCLUDES
#	include <memory.h>
#endif
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xew/Basic.h>
#include <X11/Xew/Raster.h>
#include <X11/Xew/Audio.h>
#include <X11/Xew/TextEd.h>
#include <X11/Xew/Support.h>
#if SYSV_INCLUDES || ANSI_INCLUDES
#	include <limits.h>
#else
#ifndef LONG_MAX
#define LONG_MAX (~((unsigned long)0L)>>1)
#endif
#endif

#include "ui_tools.h"

static Widget root_widget;
static Widget edit_widget;	/* TextEd widget instance */
static char *edit_file;		/* Current primary file */
static Widget edit_title;	/* Label Widget for filename */
static int text_modified;	/* True if text modified */

typedef enum
    {
	FileMenu_None,
	FileMenu_SaveAs,
	FileMenu_LoadFile
    } FileMenuAction;


static Position AdjustCoord(x, y, a, b)
int x, a, b;
    {
	if (x < a)
		a = x;
	else if (x + y >= a + b)
		a = x + y - b;
	return a;
    }

/*
** Sample Notify skeleton..
*/
static void Notify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeNotifyCallbackData *notify = (XeNotifyCallbackData *)call_data;
	XeNotifyAreaCallbackData *area;
	int i;
	Position x, y;

	switch (notify->reason)
	    {
	    case XeCR_NOTIFY:
		/* Quickhack: just assume it's a button event! */
		printf("Notify(");
		for (i = 0; i < notify->num_params; i++)
			printf("%s%s", i==0?"":",", notify->params[i]);
		printf(") at (%d,%d)\n",
		       (int)notify->event->xbutton.x,
		       (int)notify->event->xbutton.y);
		break;
	    case XeCR_NOTIFY_AREA:
		area = (XeNotifyAreaCallbackData *)call_data;
		x = AdjustCoord(area->area.x, area->area.width,
				area->visible.x, area->visible.width);
		y = AdjustCoord(area->area.y, area->area.height,
				area->visible.y, area->visible.height);
#if X11R5
		if (x != area->visible.x || y != area->visible.y)
			XawViewportSetCoordinates(XtParent(w), x, y);
#endif
		break;
	    default:
		printf("UNKNOWN: XeRC=%d\n");
		break;
	    }
    }

static void Modify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	text_modified = True;
    }

static void SelectAll(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeTextSetSelection(edit_widget, (long)0, (long)LONG_MAX);
    }

static void InsertText(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	long pos = XeTextGetInsertionPoint(edit_widget);

	if (!client_data)
		return;
	XeTextReplace(edit_widget, pos, pos,
		      (char *)client_data, strlen((char *)client_data));
    }

/*
** SetFilenameToTitle
*/
static void SetFilenameToTitle()
    {
	Arg args[1];
	char *label = edit_file ? edit_file : "(noname)";

	XtSetArg(args[0], XtNlabel, label);
	XtSetValues(edit_title, args, (Cardinal)1);
    }

/*
** File dialog is copied and modified from X11R5 editres client code!
*/
static void  PopdownFileDialog(w, client_data, junk)
Widget w;
XtPointer client_data, junk;
    {
	Widget dialog = XtParent(w);
	
	if ((FileMenuAction)client_data)
	    {
		String filename = XawDialogGetValueString(dialog);
		Cardinal n;
		Arg args[2];

		switch ((FileMenuAction)client_data)
		    {
		    case FileMenu_SaveAs:
			if (XeTextSaveAsFile(edit_widget, filename))
				text_modified = False;
			break;
		    case FileMenu_LoadFile:
			n = 0;
			XtSetArg(args[n], XtNcontentFile, filename); n++;
			XtSetArg(args[n], XtNcontentLoaded, False); n++;
			XtSetValues(edit_widget, args, n);
			text_modified = False;
			break;
		    default:
			break;
		    }
		if (edit_file)
			free(edit_file);
		edit_file = strdup(filename);
		SetFilenameToTitle();
	    }
	XtPopdown(XtParent(dialog));
    }


static void  ClearModifiedFlag(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Widget dialog = XtParent(w);

	if ((int)client_data)
		text_modified = False;
	XtPopdown(XtParent(dialog));
    }


static void SaveToFile(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	if (XeTextSaveAsFile(edit_widget, edit_file))
		text_modified = False;
    }


static UI_DialogDef popup_dialog_saveas =
    {
	"File name: ",
	"",
	PopdownFileDialog,
	(XtPointer)FileMenu_SaveAs,
    };

static UI_DialogDef popup_dialog_loadfile =
    {
	"File name: ",
	"",
	PopdownFileDialog,
	(XtPointer)FileMenu_LoadFile,
    };


UI_ElementDef paragraph_control[] =
    {
	UI_PANE(" "),
	UI_TOGGLE("wrap lines",		True),
	UI_LOAD(XtNformat),
	UI_TOGGLE("proportional spacing", True),
	UI_LOAD(XtNproportional),
	UI_INPUT("line spacing"),
	UI_LOAD(XtNlineSpacing),
	UI_INPUT("indentation:"),
	UI_LOAD(XtNindentation),
	UI_INPUT("first line offset:"),
	UI_LOAD(XtNfirstLineOffset),
#if 1
	UI_INPUT("itemization:"),
	UI_LOAD(XtNitemization),
#endif
	UI_INPUT("column width:"),
	UI_LOAD(XtNcolumnWidth),
	UI_PANE("Default Alignment:"),
	UI_TOGGLE("start (ragged right)",XeAlignment_START),
	UI_RADIO("end (ragged left)",	XeAlignment_END),
	UI_RADIO("centered",		XeAlignment_CENTER),
	UI_RADIO("justified",		XeAlignment_JUSTIFIED),
	UI_LOAD(XtNalignment),
	UI_END(),
    };

UI_ElementDef export_control[] =
    {
	UI_PANE("Export format:"),
	UI_TOGGLE("string",		XeTextExport_STRING),
	UI_RADIO("string (F)",		XeTextExport_STRING_F),
	UI_RADIO("character odif",	XeTextExport_ODIF),
	UI_RADIO("character odif (F)",	XeTextExport_ODIF_F),
	UI_RADIO("character odif (FP)",	XeTextExport_ODIF_FP),
	UI_LOAD(XtNexportFormat),
	UI_END(),
    };

UI_ElementDef insert_state[] =
    {
	/* *NOTE* The control sequences in data assume the C compiler is
	   is using ASCII code set. --msa */
	UI_PANE(	" "),
	UI_TOGGLE(	"Normal intensity",	"\033[22m"),
	UI_RADIO(	"Bold",			"\033[1m"),
	UI_TOGGLE(	"Italic",		"\033[3m"),
	UI_RADIO(	"Not italic",		"\033[23m"),
	UI_TOGGLE(	"Underlined",		"\033[4m"),
	UI_RADIO(	"Double underlined",	"\033[21m"),
	UI_RADIO(	"Not underlined",	"\033[24m"),
	UI_TOGGLE(	"Inverse", 		"\033[7m"),
	UI_RADIO(	"Not inversed",		"\033[27m"),
	UI_TOGGLE(	"Crossed out", 		"\033[9m"),
	UI_RADIO(	"Not crossed out", 	"\033[29m"),
	UI_TOGGLE(	"Superscript",		"\033L\033L"),
	UI_RADIO(	"Baseline",		"\033K\033K\033L"),
	UI_RADIO(	"Subscript",		"\033K\033K"),
	UI_TOGGLE(	"Default aligned",	"\033[0 F"),
	UI_RADIO(	"Justified",		"\033[2 F"),
	UI_RADIO(	"Start aligned",	"\033[5 F"),
	UI_RADIO(	"Centered",		"\033[6 F"),
	UI_TOGGLE(	"End aligned",		"\033[7 F"),
	UI_PANE(	"Foreground:"),
	UI_TOGGLE(	"Default",		"\033[39m"),
	UI_RADIO(	"Black",		"\033[30m"),
	UI_RADIO(	"Red",			"\033[31m"),
	UI_RADIO(	"Green",		"\033[32m"),
	UI_RADIO(	"Yellow",		"\033[33m"),
	UI_RADIO(	"Blue",			"\033[34m"),
	UI_RADIO(	"Magenta",		"\033[35m"),
	UI_RADIO(	"Cyan",			"\033[36m"),
	UI_RADIO(	"White",		"\033[37m"),
	UI_LABEL(	"Background:"),
	UI_TOGGLE(	"Default",		"\033[49m"),
	UI_RADIO(	"Black",		"\033[40m"),
	UI_RADIO(	"Red",			"\033[41m"),
	UI_RADIO(	"Green",		"\033[42m"),
	UI_RADIO(	"Yellow",		"\033[43m"),
	UI_RADIO(	"Blue",			"\033[44m"),
	UI_RADIO(	"Magenta",		"\033[45m"),
	UI_RADIO(	"Cyan",			"\033[46m"),
	UI_RADIO(	"White",		"\033[47m"),
	UI_PANE(	"Font:"),
	UI_TOGGLE(	"primary (default)",	"\033[10m"),
	UI_RADIO(	"First alternative",	"\033[11m"),
	UI_RADIO(	"Second alternative",	"\033[12m"),
	UI_RADIO(	"Third alternative",	"\033[13m"),
	UI_RADIO(	"Fourth alternative",	"\033[14m"),
	UI_RADIO(	"Fifth alternative",	"\033[15m"),
	UI_RADIO(	"Sixth alternative",	"\033[16m"),
	UI_RADIO(	"Seventh alternative",	"\033[17m"),
	UI_RADIO(	"Eight alternative",	"\033[18m"),
	UI_RADIO(	"Ninth alternative",	"\033[19m"),
	UI_PANE(	"Character set:"),
	UI_TOGGLE("iso8859-1 (Latin No.1)","\33(B\33)B\33.A\33/A\17\33\155"),
	UI_RADIO("iso8859-2 (Latin No.2)","\33(B\33)B\33.B\33/B\17\33\155"),
	UI_RADIO("iso8859-3 (Latin No.3)","\33(B\33)B\33.C\33/C\17\33\155"),
	UI_RADIO("iso8859-4 (Latin No.4)","\33(B\33)B\33.D\33/D\17\33\155"),
	UI_RADIO("iso8859-5 (Latin/Cyrillic)","\33(B\33)B\33.L\33/L\17\33\155"),
	UI_RADIO("iso8859-6 (Latin/Arabic)","\33(B\33)B\33.G\33/G\17\33\155"),
	UI_RADIO("iso8859-7 (Latin/Greek)","\33(B\33)B\33.F\33/F\17\33\155"),
	UI_RADIO("iso8859-8 (Latin/Hebrew)","\33(B\33)B\33.H\33/H\17\33\155"),
	UI_RADIO("iso8859-9 (Latin No.5)","\33(B\33)B\33.M\33/M\17\33\155"),
	UI_RADIO("iso6937","\33(B\33)B\33.R\33/R\17\33\155"),
	UI_RADIO("iso646-se",		"\33(G\33)G\33.A\33/A\17\33\155"),
	UI_RADIO("iso646-se (names)",	"\33(H\33)H\33.A\33/A\17\33\155"),
	UI_RADIO("JIS C 6226-1983",	"\33(B\33)B\33$*B\33$+B\17\33\155"),
	UI_RADIO("KSC 5601-1987",	"\33(B\33)B\33$*C\33$+C\17\33\155"),
	UI_RADIO("GB 2312-80",		"\33(B\33)B\33$*A\33$+A\17\33\155"),
	UI_END(),
    };

static char *GetCurrentInsertState()
    {
	static char *current;
	static int size;

	struct UI_ElementDef *r;
	Arg args[1];
	Boolean state;
	char *s;
	int i;

	for (i = 0, r = insert_state; r->op != UI_EndOp; ++r)
		switch (r->op)
		    {
		    case UI_ToggleOp:
		    case UI_RadioOp:
			if (!r->widget || !r->data)
				break;
			XtSetArg(args[0], XtNstate, &state);
			XtGetValues(r->widget, args, 1);
			if (state)
			    {
				int length = strlen((char *)r->data);

				if (i + length >= size)
				    {
					size = (size + length + 50) / 50 * 50;
					current = XtRealloc(current, size);
				    }
				strcpy(current + i, (char *)r->data);
				i += length;
			    }
			break;
		    default:
			break;
		    }
	return i > 0 ? current : NULL;
    }

static void SetInsertState(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Arg args[1];
	long start, end;

	XtSetArg(args[0], XtNinitialState, GetCurrentInsertState());
	XtSetValues(edit_widget, args, 1);
	/*
	** If a selection is currently active, then extract the selected
	** text away from the widget, and then replace the text with the
	** extracted text. This is rather inefficient way of getting the
	** attributes of the selected text to change as defined by the
	** input state.
	**
	** NOTE:As the selected content is effected by the currently
	**	chosen export format, some information may be lost,
	**	if the format is too simple (like string).
	*/
	XeTextGetSelectionPosition(edit_widget, &start, &end);
	if (end > start)
	    {
		long length;
		String value;

		value = XeTextGetSubstring(edit_widget, &length, start, end);
		XeTextReplace(edit_widget, start, end, value, length);
		XeTextUnsetSelection(edit_widget);
		XtFree(value);
	    }
    }

static void SetTargetAndPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;

	if (panel)
	    {
		panel->target = edit_widget;
		UI_PopupPanel(w, client_data, call_data);
	    }
    }

static UI_DialogDef query_reset_modified =
    {
	"Text has been modified--clear flag?",
	NULL,
	ClearModifiedFlag,
	(XtPointer)True,
    };

static void CheckForModify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	if (text_modified)
		UI_PopupDialog(w, (XtPointer)&query_reset_modified, call_data);
	else
		UI_PopupDialog(w, client_data, call_data);
    }

static void CheckModifyForQuit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	if (text_modified)
		UI_PopupDialog(w, (XtPointer)&query_reset_modified, call_data);
	else
		UI_Quit(w, client_data, call_data);
    }

static UI_PanelDef popup_export_control =
    {
	"Change Layout and Export",
	export_control,
	UI_AcceptPanel,
	(XtPointer)&popup_export_control,
    };

static UI_PanelDef popup_insert_state =
    {
	"Change Input State",
	insert_state,
	SetInsertState,
    };

static UI_PanelDef popup_paragraph_control =
    {
	"Paragraph settings",
	paragraph_control,
	UI_AcceptPanel,
	(XtPointer)&popup_paragraph_control,
    };

static UI_MenuItemDef file_menu_items[] =
    {
	{"Save", SaveToFile, (XtPointer)NULL,},
	{"Save as", UI_PopupDialog, (XtPointer)&popup_dialog_saveas,},
	{"Load File", CheckForModify, (XtPointer)&popup_dialog_loadfile,},
	{"Quit", CheckModifyForQuit, NULL},
	{NULL},
    };

static UI_MenuDef file_menu =
    {
	"File",
	file_menu_items,
    };

static UI_MenuItemDef edit_menu_items[] =
    {
	{"Character format", SetTargetAndPopup,
		 (XtPointer)&popup_insert_state,},
	{"Paragraph format", SetTargetAndPopup,
		 (XtPointer)&popup_paragraph_control,},
	{"Export format", SetTargetAndPopup,
		 (XtPointer)&popup_export_control,},
	{"Select all", SelectAll, (XtPointer)NULL},
	{NULL},
    };

static UI_MenuDef edit_menu =
    {
	"Edit",
	edit_menu_items,
    };

static UI_MenuItemDef insert_menu_items[] =
    {
	{"Paragraph", InsertText, (XtPointer)"\036",},
	{"Quad left", InsertText, (XtPointer)"\033[0 H",},
	{"Quad center", InsertText, (XtPointer)"\033[2 H",},
	{"Quad right", InsertText, (XtPointer)"\033[4 H",},
	{"Quad Justify", InsertText, (XtPointer)"\033[6 H",},
	{NULL},
    };

static UI_MenuDef insert_menu =
    {
	"Insert",
	insert_menu_items,
    };

#include "fallback.c"

main(argc, argv)
int argc; char *argv[];
    {
	XtAppContext demo_application;
	Widget view, widget, pane, box, button;
	Arg args[10];
	int n;
	XeContentFormat content_type;

	root_widget = XtAppInitialize(&demo_application, "TextEd",
				      NULL,0, &argc, argv,
				      fallback_resources, NULL, 0);
	UI_Initialize(demo_application);

	edit_file = argc > 1 ? strdup(argv[1]) : NULL;

	n = 0;
	pane = XtCreateManagedWidget
		("pane", panedWidgetClass, root_widget, args, n);
	n = 0;
	box = XtCreateManagedWidget
		("box", boxWidgetClass, pane, args, n);

	UI_CreateMenu(box, &file_menu);
	UI_CreateMenu(box, &edit_menu);
	UI_CreateMenu(box, &insert_menu);

	n = 0;
	XtSetArg(args[n], XtNborderWidth, 0); ++n;
	edit_title = XtCreateManagedWidget("fileName", labelWidgetClass,
					  box, args, n);
	SetFilenameToTitle();
	/* XtAppSetWarningMsgHandler(demo_application, UI_PopupMessage); */
	n = 0;
	XtSetArg(args[n], XtNallowHoriz, True); ++n;
	XtSetArg(args[n], XtNallowVert, True); ++n;
	XtSetArg(args[n], XtNshowGrip, False); ++n;
	view = XtCreateManagedWidget("demoTextEd", viewportWidgetClass,
				     pane,args, n);
	content_type = XeFindContentFormat(edit_file);
	n = 0;
	XtSetArg(args[n], XtNcontentFile, edit_file); ++n;
	XtSetArg(args[n], XtNcontentFormat, content_type); ++n;
	if (content_type == XeContentFormat_UNKNOWN)
	    {
		/*
		** Request proportional spacing, because we are not
		** specifying the lineSpacing.
		*/
		XtSetArg(args[n], XtNproportional, True); ++n;
		XtSetArg(args[n], XtNcolumnWidth, 400); ++n;
		edit_widget = XtCreateManagedWidget
			("TextEdit", xeTextEdWidgetClass, view, args, n);
	    }
	else if (content_type == XeContentFormat_AUDIO)
	    {
		XtSetArg(args[n], XtNplay, XePlay_FREEZE); ++n;
		edit_widget = XtCreateManagedWidget
			("AudioEdit", xeAudioWidgetClass, view, args, n);
	    }
	else
	    {
		XtSetArg(args[n], XtNscaling, XeScaling_NONE); ++n;
		edit_widget = XtCreateManagedWidget
			("EditRaster", xeRasterWidgetClass, view, args, n);
	    }
	XtAddCallback(edit_widget, XtNnotifyCallback, Notify, (XtPointer)NULL);
	XtAddCallback(edit_widget, XtNmodifyCallback, Modify, (XtPointer)NULL);
	XtRealizeWidget(root_widget);
	XtAppMainLoop(demo_application);
	return 0;
    }
