/*
** Copyright 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/VideoP.h>
#include "mpeg_video.h"
#include "VideoMPEG.h"
#include "ImageTools.h"
#include "VideoImage.h"

/*
** video_playing
**	stores the current widget. The decoder has no context passed to
**	get_more_data, thus a module global is needed.
*/
static XeVideoWidget video_playing;
static int eof_flag;

/*
** External functions used (these should be in some .h file!!)
** -----------------------------------------------------------
*/
#if NeedFunctionPrototypes

extern VidStream *NewVidStream(int bufLength);
extern VidStream *mpegVidRsrc (TimeStamp, VidStream *);
extern void DestroyVidStream (VidStream *);
#else
extern VidStream *NewVidStream();
extern VidStream *mpegVidRsrc();
extern void DestroyVidStream();
#endif

#define BUF_LENGTH 40000

/*
 *--------------------------------------------------------------
 *
 * get_more_data --
 *
 *	Called by correct_underflow in bit parsing utilities to
 *      read in more data.
 *
 * Results:
 *	Input buffer updated, buffer length updated.
 *      Returns 1 if data read, 0 if EOF, -1 if error.
 *
 * Side effects:
 *      None.
 *
 *--------------------------------------------------------------
 */
#if NeedFunctionPrototypes
int get_more_data(unsigned int *buf_start, int max_length, int *length_ptr,
		  unsigned int **buf_ptr)
#else
int get_more_data(buf_start, max_length, length_ptr, buf_ptr)
unsigned int *buf_start;
int max_length;
int *length_ptr;
unsigned int **buf_ptr;
#endif
    {
	if (eof_flag)
		return 0;
	if (*length_ptr > 0)
		memcpy((void *)buf_start, (void *)*buf_ptr,
		       (*length_ptr * sizeof(int)));
	*buf_ptr = buf_start;
	/*
	** Make 32 bits after end equal to 0 and 32 bits after that equal
	** to seq end code in order to prevent messy data from infinite
	** recursion.
	*/
	*(buf_start + *length_ptr) = 0x0;
	*(buf_start + *length_ptr+1) = SEQ_END_CODE;
	eof_flag = 1;
	return 0;
    }

/*
** GrabLastImage
**	The raw_image structure in video widget only refers to the
**	mpeg decoder buffers while video is running. These structures
**	will disappear when the VidStream is destroyed. GrabLastImage
**	makes a private copy of the current image being displayed.
*/
static void GrabLastImage(w, vs)
XeVideoWidget w;
VidStream *vs;
    {
	XeRawImage *raw = w->video.raw_image;
	int size_Y, size_Cb, size_Cr;
	unsigned char *addr_Y, *addr_Cb, *addr_Cr;

	if (raw == NULL || raw->num_channels != 3)
		return;
	if (vs == NULL)
	    {
		if (!raw->alloc_data)
			raw->num_channels = 0; /* nothing left to show */
		return;
	    }
	if (raw->alloc_data)
		XtFree((char *)raw->data);
	size_Y  = raw->channel[0].h * raw->channel[0].line;
	size_Cb = raw->channel[1].h * raw->channel[1].line;
	size_Cr = raw->channel[2].h * raw->channel[2].line;
	raw->alloc_data = True;
	raw->data = (unsigned char *)XtMalloc(size_Y + size_Cb + size_Cr);
	addr_Y  = raw->data;
	addr_Cb = addr_Y  + size_Y;
	addr_Cr = addr_Cb + size_Cb;
	memcpy((void *)addr_Y,  (void *)raw->channel[0].addr, size_Y);
	memcpy((void *)addr_Cb, (void *)raw->channel[1].addr, size_Cb);
	memcpy((void *)addr_Cr, (void *)raw->channel[2].addr, size_Cr);
	raw->channel[0].addr = addr_Y;
	raw->channel[1].addr = addr_Cb;
	raw->channel[2].addr = addr_Cr;
    }

static void XeVideoClosePlay_MPEG(w, notify)
XeVideoWidget w;
XeVideoNotify notify;
    {
	VidStream *vs = (VidStream *)w->video.decoder;
	w->video.decoder = NULL;
	GrabLastImage(w, vs);
	if (vs)
		DestroyVidStream(vs);
    }

static int XeVideoOpenPlay_MPEG(w)
XeVideoWidget w;
    {
	VidStream *vs = (VidStream *)w->video.decoder;
	XeRawImage *raw;

	if (vs)
		XeVideoClosePlay_MPEG(w);
	totNumFrames = 0;
	video_playing = w;
	vs = NewVidStream(BUF_LENGTH);
	w->video.decoder = (XtPointer)vs;
	_XeDestroyRawImage(w->video.raw_image);
	w->video.raw_image = raw = _XeCreateRawImage(3);
	raw->class = XeImageClass_FULLCOLOR;
	raw->color_space = XeImageSpace_YCbCr;
	raw->samples_per_pixel = 3;
	raw->bits_per_sample = 8;
	raw->bits_per_component = 8;
	raw->bytes_per_line =  0;
	raw->num_channels = 0;	/* NO REAL DATA YET!!! */
	return 0;
    }

/*
** XeVideoWorkPlay_MPEG
**	This function is called from the Video.c when more data should
**	be decoded.
**
**	Return the number of octets actually accepted.
*/
static int XeVideoDecodePlay_MPEG(w, data, length)
XeVideoWidget w;
char *data;
int length;
    {
	int *src, *dst, n, i;
	VidStream *vs = (VidStream *)w->video.decoder;

	if (vs == NULL)
		return -1;
	if (vs->buf_length > vs->max_buf_length / 2)
		/*
		** An kludge that hopefully lessens the amount of
		** copying of data: if the buffer is more than half
		** full, hold off adding the data for now. --msa
		*/
		length = 0;
	else if (length > 0 && length < sizeof(int))
	    {
		/*
		** Another sometimes *non-working* kludge: if the length
		** of data offered is less than sizeof(int), then assume
		** this is the last part of the stream (surely a false
		** assumption, if the input is from the socket, but then
		** this decoder can't deal with them anyway due the way
		** get_more_data is used... --msa
		*/
		vs->buffer[vs->buf_length] = htonl(*(int *)data);
		vs->buf_length += 1;
	    }
	else if (length > 0)
	    {
		if (vs->buf_length > 0)
			memcpy((unsigned char *)vs->buf_start, vs->buffer,
			       vs->buf_length * sizeof(int));
		vs->buffer = vs->buf_start;
		dst = (int *)(vs->buf_start + vs->buf_length);
		src = (int *)data;
		n = length / sizeof(int);
		if (n > (vs->max_buf_length - vs->buf_length))
			n = vs->max_buf_length - vs->buf_length;
		for (i = 0; i < n; i++, src++)
			*dst++ = htonl(*src);
		vs->buf_length += n;
		length = n * sizeof(int);
	    }
	else if (vs->buf_length == 0)
		return -1;
	video_playing = w;
	eof_flag = 0;
	if (setjmp(vs->env) == 0)
		vs = mpegVidRsrc(0, vs);
	else
	    {
		GrabLastImage(w, vs);
		DestroyVidStream(vs);
		vs = NULL;
	    }
	video_playing = 0;
	w->video.decoder = (XtPointer)vs;
	if (vs)
	    {
		w->video.width = vs->h_size;
		w->video.height = vs->v_size;
	    }
	return length;
    }

static void XeVideoCleanup_MPEG(w)
XeVideoWidget w;
    {
    }

/*
 *--------------------------------------------------------------
 *
 * ExecuteDisplay --
 *
 *	Actually displays display plane in previously created window.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */
void ExecuteDisplay(vid_stream)
VidStream *vid_stream;
    {
	XeRawImage *raw;
	XeVideoWidget w = video_playing;
	
	if (!w)
		return;
	w->animation.frame_num += 1;
	if (w->animation.current_frame == w->animation.frame_num &&
	    w->animation.frame_callbacks)
	    {
		XeAnimationFrameCallbackData data;

		data.reason = XeCR_ANIMATION_FRAME;
		data.frame = w->animation.frame_num;
		XtCallCallbackList((Widget)w, w->animation.frame_callbacks,
				   (XtPointer)&data);
	    }
	if (w->animation.first_frame > w->animation.frame_num)
		return;
	if ((raw = w->video.raw_image) != NULL)
	    {
		raw->width = vid_stream->h_size;
		raw->height = vid_stream->v_size;
		raw->channel[0].addr = vid_stream->current->luminance;
		raw->channel[0].w = raw->width;
		raw->channel[0].h = raw->height;
		raw->channel[0].line = vid_stream->mb_width * 16;
		raw->channel[0].inc = 1;
		/* Note: swapping Cr and Cb. Somewhere there is confusion
		   and with berkeley MPEG they need be flipped... --msa */
		raw->channel[1].addr = vid_stream->current->Cr;
		raw->channel[1].w = raw->width / 2;
		raw->channel[1].h = raw->height / 2;
		raw->channel[1].inc = 1;
		raw->channel[1].line = raw->channel[0].line / 2;
		raw->channel[2] = raw->channel[1];
		raw->channel[2].addr = vid_stream->current->Cb;
		raw->num_channels = 3; /* Now we have something! */
		XeVideoImage(w);
	    }
    }

/*
** XeVideo_MPEG
**	Initialize MPEG decoder
*/
void XeVideo_MPEG(w)
XeVideoWidget w;
    {
	static int static_init;

	if (!static_init)
	    {
		static_init = 1;
		init_tables();
	    }
	w->video.open_play = XeVideoOpenPlay_MPEG;
	w->video.decode_play = XeVideoDecodePlay_MPEG;
	w->video.close_play = XeVideoClosePlay_MPEG;
	w->video.video_cleanup = XeVideoCleanup_MPEG;
    }
