/*
** RasterLayout
**
**	This module must build up the Display version of the
**	raster image, creating the XImage structure. This should be
**	called whenever the content, image dimensions or anything
**	affecting the presentation changes.
**
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/RasterP.h>

#include "RasterLayout.h"
#include "ImageTools.h"

/*
** MirrorRotation
**	Setup line, inc and start parameters according to the rotation
**	and mirror parameters.
*/
static void MirrorRotation(rot, mirror, src, dst)
int rot, mirror;
XeImageChannel *src, *dst;
    {
	int last_col = (src->w - 1) * src->inc;
	int last_row = (src->h - 1) * src->line;

	while (rot < 0)
		rot += 360;
	rot = (((rot % 360 + 45)) / 90) * 90;
	if (rot == 0)
	    {
		dst->w = src->w;
		dst->h = src->h;
		dst->line = src->line;
		dst->inc = mirror ? -src->inc : src->inc;
		dst->addr = &src->addr[(mirror ? last_col : 0)];
	    }
	else if (rot == 90)
	    {
		dst->w = src->h;
		dst->h = src->w;
		dst->line = mirror ? -src->inc : src->inc;
		dst->inc = -src->line;
		dst->addr = &src->addr[last_row + (mirror ? 0 : last_col)];
	    }
	else if (rot == 180)
	    {
		dst->w = src->w;
		dst->h = src->h;
		dst->line = -src->line;
		dst->inc = mirror ? src->inc : -src->inc;
		dst->addr = &src->addr[last_row + (mirror ? last_col : 0)];
	    }
	else if (rot == 270)
	    {
		dst->w = src->h;
		dst->h = src->w;
		dst->line = mirror ? src->inc : -src->inc;
		dst->inc = src->line;
		dst->addr = &src->addr[mirror ? 0 : last_col];
	    }
    }

void XeRasterLayout(w)
XeRasterWidget w;
    {
	XImage *image;
	XeRawImage *raw = w->raster.raw_image;
	XeImageChannel data[4];
	int i, pixel_size;

	_XeDestroyImage((XeBasicWidget)w, w->raster.dsp_image);
	w->raster.dsp_image = NULL;
	w->raster.done = True;	/* Consider done, whether errors or not */
	if (raw == NULL)
		return;		/* Nothing to layout */
	w->raster.dsp_image = _XeCreateImage
		((XeBasicWidget)w, w->raster.raw_image,
		 w->raster.dither, w->raster.color_quantize);
	if (w->raster.dsp_image == NULL ||
	    (image = w->raster.dsp_image->image) == NULL)
		return;
	data[0].addr = (unsigned char *)image->data;
	data[0].w = image->width;
	data[0].h = image->height;
	data[0].line = image->bytes_per_line;
	data[0].inc = (image->bits_per_pixel + 7) / 8;
	pixel_size = raw->bits_per_component * raw->samples_per_pixel;
	for (i = 1; i <= raw->num_channels && i < XtNumber(data); i++)
	    {
		/* Rotation/mirror work only for >=8 bit channels */
		if (pixel_size < 8)
			data[i] = raw->channel[i-1];
		else
			MirrorRotation(w->basic.rotation,
				       w->basic.mirror_image,
				       &raw->channel[i-1],  &data[i]);
	    }
	_XeBuildImage((XeBasicWidget)w, w->raster.dsp_image, i, data);
    }






