#ifndef _XewBasic_h
#define _XewBasic_h
/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Converters.h>

#ifndef _XFUNCPROTOBEGIN
#	define _XFUNCPROTOBEGIN
#	define _XFUNCPROTOEND
#endif

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 colormapUse         ColormapUse        XeColormapUse   XeColormapUse_SHARED
 colormapInstall     ColormapInstall    Boolean         False
 colorMode           ColorMode          XeColorMode     XeColorMode_COLOR
 contentFile         ContentFile        String          NULL
 contentFormat       ContentFormat      XeContentFormat XeContentFormat_UNKNOWN
 contentLoaded       ContentLoaded      Boolean         False
 contentLength       ContentLength      long            0
 contentOffset       ContentOffset      long            0
 contentStream       ContentStream      FILE *          NULL
 contentString       ContentString      Pointer         NULL
 destroyCallback     Callback		Pointer		NULL
 exposeCallback      ExposeCallback     Pointer         NULL
 cursor              Cursor             Cursor          None
 foreground	     Foreground		Pixel		XtDefaultForeground
 height	             Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 maxColors           MaxColors          int             MAXINT
 mirrorImage         MirrorImage        Boolean         False
 notifyCallback      NotifyCallback     Pointer         NULL
 resize              Resize             Boolean         True
 scaling             Scaling            XeScaling       XeScaling_WIDTH
 rotation            Rotation           int             0
 useShm              UseShm             Boolean         False
 visual              Visual             Visual *        NULL
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0
*/

typedef enum
    {
	XeContentFormat_UNKNOWN,/* Unknown format */
	XeContentFormat_ISO2022,/* ISO 2022 octet stream */
	XeContentFormat_TIFF,	/* TIFF 6.0 Base line */
	XeContentFormat_JPEG,	/* JPEG/JFIF stream */
	XeContentFormat_GIF,	/* GIF89a stream */
	XeContentFormat_CGM,	/* CGM octet stream */
	XeContentFormat_H261,	/* H.261 octet stream */
	XeContentFormat_AUDIO,	/* 8kHz u-law stream */
	XeContentFormat_ODIF,	/* ODA/ODIF stream */
	XeContentFormat_MPEG,	/* MPEG I video stream */
	XeContentFormat_PBM	/* PBMPLUS Image streams */
    } XeContentFormat;

typedef enum
    {
	XeScaling_NONE,		/* No scaling, visualize in real size */
	XeScaling_WIDTH,	/* Width controlled, preserve aspect ratio */
	XeScaling_HEIGHT,	/* Height controlled, preserve aspect ratio */
	XeScaling_MAXASPECT,	/* Max size withing window, preserve aspect */
	XeScaling_FITAREA	/* Fit exactly into window, change aspect */
    } XeScaling;

typedef enum
    {
	XeColormapUse_SHARED,
	XeColormapUse_SHAREDOWN,
	XeColormapUse_OPTIONAL,
	XeColormapUse_PRIVATE
    } XeColormapUse;

typedef enum
    {
	XeColorMode_NONE,	/* Not Used */
	XeColorMode_MONO,	/* Use Bi-level (black/white) */
	XeColorMode_GRAY,	/* Use Gray Scale (if possible) */
	XeColorMode_COLOR	/* Use colors (if possible) */
    } XeColorMode;

/*
** XeDither
**	is not really a Basic resource, but is used by at least
**	Raster and Video, and thus needs to be defined for both
**	of them.
**
**	Specify whether dithering algorithm is to be used.
*/
typedef enum
    {
	XeDither_NONE,		/* No dithering */
	XeDither_FS4		/* Floyd-Sternberg with 4 errors */
    } XeDither;

/*
** XeColorQuantize
**	is not really a Basic resource, but is used by at least
**	Raster and Video, and thus needs to be defined for both
**	of them.
**
**	Specify how 24bit colors are to be presented on pseudocolor
**	displays.
*/
typedef enum
    {
	XeColorQuantize_FAST,	/* "Colorcube" mapping with/without dither */
	XeColorQuantize_HECKBERT,/* (from xv) Heckbert's Median Cut */
	XeColorQuantize_PPMQUANT,/* (from xv/PBMPLUS, ppmquant) */
	XeColorQuantize_JPEG	/* IJG quantification, only for jpeg images */
    } XeColorQuantize;

/*
** Known callback reasons in Xe widgets
*/
typedef enum
    {
	XeCR_UNKNOWN,		/* Unspecified callback reason */
	XeCR_NOTIFY,		/* Universal default reason for notify() */
	XeCR_NOTIFY_AREA,	/* Area of interest report */
	XeCR_EXPOSE,		/* Expose callback */
	XeCR_MODIFY_TEXT,	/* Text Content Modified */
	XeCR_LAYOUT_CHANGE_TAG,	/* Text Layout callback */
	XeCR_LAYOUT_BEGIN_LINE,	/* Text Layout callback */
	XeCR_ANIMATION_DONE,	/* Animation (video, audio) done callback */
	XeCR_ANIMATION_FRAME	/* Animation (video, audio) fram callback */
    } XeCR;

/*
** XeCallData
**	is the general structure that is passed to all Xew callbacks in
**	Xew. Individual widget classes may have further extra fields and
**	have an alternate definition for the structure and different
**	callbacks, but the beginning always matches this structure.
**
**	NOTE:	The callback reason codes will be globally unique across
**		all Xe widgets (the reason code alone can be used to decide
**		about the actual structure that applies to call_data,
**		regardless of the source widget of the callback).
*/
typedef struct XeCallbackData
    {
	int reason;		/* Reason of the callback */
    } XeCallbackData;

/*
** XeNotifyCallData
**	is the universal default data for the notify callback.
*/
typedef struct XeNotifyCallbackData
    {
	int reason;		/* == XeCR_NOTIFY == */
	XEvent *event;		/* event that triggered the callback */
	String *params;		/* Point to args of 'notity(args)' */
	Cardinal num_params;	/* Number of arguments in 'args' */
    } XeNotifyCallbackData;

/*
** XeNotifyAreaCallbackData
**	is the data supplied for the XeCR_NOTIFY_AREA callback. This
**	callback is made via general XtNnotifyCallback. The widget uses
**	this callback when it detects that the area of interest shifts
**	outside the current parent window pounds (like moving the cursor
**	out of displayed area in Text Widget). This information can be
**	used to control vieports, portholes and similar constructs.
*/
typedef struct XeNotifyAreaCallbackData
    {
	int reason;		/* == XeCR_NOTIFY_AREA == */
	XRectangle area;	/* Area of interest */
	XRectangle visible;	/* Visiblea are of the window */
    } XeNotifyAreaCallbackData;

/*
** XeExposeCallbackData
**	is the data spplied for the XeCR_EXPOSE callback. This callback
**	is made via XtNexposeCallback after all of the widgets own
**	expose processing has been completed.
*/
typedef struct XeExposeCallbackData
    {
	int reason;		/* == XeCR_EXPOSE */
	XExposeEvent *event;	/* event that triggered the callback */
	Region region;		/* expose region parameter */
    } XeExposeCallbackData;
	

/* New fields */
#define XtNcolormapUse "colormapUse"
#define XtCColormapUse "ColormapUse"
#define XtRXeColormapUse "XeColormapUse"
#define XtNcolormapInstall "colormapInstall"
#define XtCColormapInstall "ColormapInstall"
#define XtNcolorMode "colorMode"
#define XtCColorMode "ColorMode"
#define XtRXeColorMode "XeColorMode"
#define XtNcolorQuantize "colorQuantize"
#define XtCColorQuantize "ColorQuantize"
#define XtRXeColorQuantize "XeColorQuantize"
#define XtNcursor "cursor"
#define XtNcontentFile "contentFile"
#define XtCContentFile "ContentFile"
#define XtNcontentFormat "contentFormat"
#define XtCContentFormat "ContentFormat"
#define XtRXeContentFormat "XeContentFormat"
#define XtNcontentLoaded "contentLoaded"
#define XtCContentLoaded "ContentLoaded"
#define XtNcontentStream "contentStream"
#define XtCContentStream "ContentStream"
#define XtNcontentString "contentString"
#define XtCContentString "contentString"
#define XtNcontentLength "contentLength"
#define XtCContentLength "ContentLength"
#define XtNcontentOffset "contentOffset"
#define XtCContentOffset "ContentOffset"
#define XtNdither "dither"
#define XtCDither "Dither"
#define XtRXeDither "XeDither"
#define XtNexposeCallback "exposeCallback"
#define XtCExposeCallback "ExposeCallback"
#define XtNmaxColors "maxColors"
#define XtCMaxColors "MaxColors"
#define XtNmirrorImage "mirrorImage"
#define XtCMirrorImage "MirrorImage"
#define XtNnotifyCallback "notifyCallback"
#define XtCNotifyCallback "NotifyCallback"
#define XtNrotation "rotation"
#define XtCRotation "Rotation"
#define XtNscaling "scaling"
#define XtCScaling "scaling"
#define XtRXeScaling "XeScaling"
#define XtRHorizontalValue "HorizontalValue"
#define XtRVerticalValue "VerticalValue"
#define XtNuseShm "useShm"
#define XtCUseShm "UseShm"
#ifndef XtNvisual
#define XtNvisual "visual"
#endif
#ifndef XtCVisual
#define XtCVisual "Visual"
#endif

/* Class record constants */

extern WidgetClass xeBasicWidgetClass;

typedef struct _XeBasicClassRec *XeBasicWidgetClass;
typedef struct _XeBasicRec      *XeBasicWidget;


#endif
