.\" $XFree86: mit/server/ddx/x386/XF86_Acc.man,v 2.16 1994/03/08 04:46:29 dawes Exp $
.\" $XConsortium: X386.man,v 1.3 91/08/26 15:31:19 gildea Exp $
.TH XF86_Accel 1 "Version 2.1"  "XFree86"
.SH NAME
XF86_Accel - 8 bit accelerated X Window System servers for UNIX on x86
platforms with an S3, Mach8, Mach32 or 8514/A accelerator board
.SH SYNOPSIS
.B XF86_S3
[:displaynumber] [ option ] ...
.LP
.B XF86_Mach8
[:displaynumber] [ option ] ...
.LP
.B XF86_Mach32
[:displaynumber] [ option ] ...
.LP
.B XF86_8514
[:displaynumber] [ option ] ...
.SH DESCRIPTION
.I XFree86
is a package of bug-fixes, enhancements, and ports of X11R5 to new OSs,
for Intel Unix-like OSs.  See the XFree86(1) manpage for details.
.PP
.I XF86_S3
is an 8-bit PseudoColor server for S3 graphic accelerator boards.  
.PP
.I XF86_Mach8
is an 8-bit PseudoColor server for ATI Mach8 graphic accelerator boards. 
.PP
.I XF86_Mach32
is an 8-bit PseudoColor server for ATI Mach32 graphic accelerator boards.  
.PP
.I XF86_8514
is an 8-bit PseudoColor server for 8514/A graphic accelerator boards.  
.PP
These are derived from the
.I X386
server provided with X11R5, and from the
.I X8514
server developed by Kevin Martin <martin@cs.unc.edu>.
.PP
The
.I XFree86
servers support all MIT-supplied extensions except the X Input Extension.
.I PEX
is supported, but does not function well on the class of hardware supported.
.SH CONFIGURATIONS
.PP
The servers support the following chipsets in 256 color mode.
.RS .5i
.TP 13
XF86_S3:
86C911, 86C924, 86C801, 86C805, 86C928
.TP 13
XF86_Mach8:
ATI Mach8, ATI Mach32
.TP 13
XF86_Mach32:
ATI Mach32
.TP 13
XF86_8514:
IBM 8514/A and true clones
.RE
.PP
For S3 virtual resolutions up to (approximately)
1152x800 are supported, using  (up to) 1Mb of display memory
(the S3 uses an internal width of 1280 except for new revisions of some of
the chips, hence 1Mb can't support 1152x900).
Physical resolutions up to 1280x1024 (1600x1280 on some cards) are
possible using 2Mb or more of display memory (virtual resolution is
dependent solely on the amount of memory installed, with the maximum
virtual width being 2048, and max virtual height is 4096).
Similar resolutions are supported on the Mach32.
For the Mach32, the maximum virtual width is 1536, and the maximum virtual
height is 1280.
For Mach8, the maximum virtual width is 1024, and 
for 8514 the maximum resolution is 1024x768.
.SH OPTIONS
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, these servers accept some more command line switches,
as described in the 
.I XFree86(1) 
manpage.
.SH "KEYBOARD"
\fIXFree86\fP provides several capabilities for easing the use of international
keyboards, and generating non-ASCII Latin-1 keysyms.  Refer to the
.I XFree86kbd(1)
manual page for more information.
.SH SETUP
.I XFree86
uses a configuration file called \fBXconfig\fP for its initial setup.  
See the 
.I Xconfig(4/5)
manpage for general details. Here only the
parts specific to the
.I XF86_S3, XF86_Mach8, XF86_Mach32, XF86_8514
servers are explained.
The \fBGRAPHICS DRIVER SETUP\fP section for the accelerated colour servers
starts with the keyword \fBaccel\fP.  
After this keyword a variety of options may be specified:
.br
.ne 3i
.TP 8
.B chipset \fI"name"\fP
specifies a chipset so the correct driver can be used.  Possible chipsets
are:
.sp
XF86_S3:
.RS 1.5i
.TP 12
s3_generic
(for a standard IO driven server) 
.TP 12
mmio_928
(for a memory mapped IO driven server on 86C928 boards)
.RE
.RS 8
.PP
XF86_Mach8:
.RE
.RS 1.5i
.TP 12
mach8
(to force the Mach8 server to run on Mach32 boards)
.RE
.RS 8
.PP
XF86_Mach32:
.RE
.RS 1.5i
.PP
mach32
.RE
.RS 8
.PP
XF86_8514:
.RE
.RS 1.5i
.PP
ibm8514
.RE
.TP 8
.B clocks \fIclock\fP  ...
specifies the dotclocks that are on your graphics board.  The clocks are
in MHz, and may be specified as a floating point number.  The value is
stored internally to the nearest kHz.  The ordering of the clocks
is important.  It must match the order in which they are selected on the
graphics board.  Multiple \fBclocks\fP lines may be specified.
For programmable clock chips the name  of the clockchip  is given.
Possible values include \fB"icd2061a"\fP and \fB"sc11412"\fP.  These
are currently only supported by the S3 server.
.TP 8
.B membase \fImemaddress\fP
specifies the hard-wired part of the linear framebuffer base address.  This
option is only used by the S3 and Mach32 servers (and only when using a
linear framebuffer).  For the S3 server, the hard-wired part is the high
6 bits of the 32-bit address (ie \fImemaddress\fP is masked with
\fI0xFC000000\fP).  For the Mach32 server, the mask is \fI0xF8000000\fP
(except for PCI cards, where the membase setting is ignored).
.sp
Note: The S3 server will normally probe for this address automatically.
Setting this option overrides that probe.  This is not normally recommended
because the failure of the server's probe usually indicates problems in
using the linear framebuffer.
.TP 8
.B option \fI"optionstring"\fP
allows the user to select certain options provided by the drivers.  Currently 
the following strings are recognized:
.sp
\fBnomemaccess\fP - (S3) disable direct access to video memory.
.sp
\fBnolinear\fP - (S3 and Mach32) disable use of a linear-mapped framebuffer.
.sp
\fBnormal_dac\fP - (S3) Card does not have one of the other RAMDACs mentioned
here.  This option is only required if the server incorrectly detects one
of those other RAMDACs.
.sp
\fBatt_20c490_1\fP - (S3) Card has an AT&T 20C490 or AT&T 20C491 RAMDAC.
This option when combined with the \fBdac_8_bit\fP option allows these
RAMDACs to be operated in 8 bit per RGB mode.  There is currently no
auto-detection for these RAMDACs.  Note that 8 bit per RGB mode does not
appear to work with the Winbond 82C490 RAMDACs (which SuperProbe identifies
as AT&T 20C492).
.sp
\fBsc15025\fP - (S3) Card has a Sierra SC15025 or SC15026 RAMDAC.
This option when combined with the \fBdac_8_bit\fP option allows these
RAMDACs to be operated in 8 bit per RGB mode.  There is currently no
auto-detection for these RAMDACs.
.sp
\fBbt485\fP - (S3) Card has a BrookTree Bt485 RAMDAC.  This option is required
if the server fails to detect the Bt485.
.sp
\fB20c505\fP - (S3) Card has an AT&T 20C505 RAMDAC.  This option is required
either if the server fails to detect the 20C505, or if the card has a Bt485
RAMDAC and there are problems using clocks higher than 67.5Mhz.
.sp
\fBbt485_curs\fP - (S3) Enables the Bt485's internal HW cursor.  This option
may be used for cards with Bt485 or AT&T 20C505 RAMDACs.
.sp
\fBti3020\fP - (S3) Card has a TI ViewPoint Ti3020 135MHz RAMDAC.  This option
is required if the server fails to detect the Ti3020.  This is the default if
a Ti3020 RAMDAC is detected and the ti3020_fast option is not set.  Note that
pixel multiplexing will be used for this RAMDAC if any mode requires a
dot clock higher than 70MHz.  Pixel multiplexing with this RAMDAC does not
support physical mode widths less than 1024 or interlaced modes.  Also, the
only logical line widths that work when operating in pixel multiplex mode
are 1024 and 2048.
.sp
\fBti3020_fast\fP - (S3) Card has a TI ViewPoint Ti3020 200MHz RAMDAC.
.sp
\fBti3020_curs\fP - (S3) Enables the Ti3020's internal HW cursor. (Default)
.sp
\fBno_ti3020_curs\fP - (S3) Disables the Ti3020's internal HW cursor.
.sp
\fBsw_cursor\fP - (Mach32) Disable the hardware cursor.
.sp
\fBdac_8_bit\fP - (S3, Mach32) Enables 8-bit per RGB.  Currently only
supported with the Ti3020, AT&T 20C490/1, Sierra SC15025/6 (S3 server)
and ATI68875/TLC34075/Bt885 (Mach32 server) RAMDACs.
.sp
\fBintel_gx\fP - (Mach32) Sets the hard-wired offset for the linear
framebuffer correctly for the Intel GX Pro cards.  This option is equivalent
to setting the \fBmembase\fP to \fI0x78000000\fP.
.sp
\fBspea_mercury\fP - (S3) Enables pixel multiplex support for SPEA Mercury
cards (928 + Bt485 RAMDAC).  For these cards, pixel multiplexing is required
in order to use dot clocks higher than 67.5 MHz and to access more than
1MB of video memory.  Pixel multiplexing is currently supported only for
non-interlaced modes, and modes with a physical width no smaller than 1024.
.PP
Note that \fIXFree86\fP has some internal capabilities to determine
what hardware
it is running on. Thus normally the keywords \fIchipset\fP, \fIclocks\fP,
and \fIvideoram\fP don't have to be specified.  But there
may be occasions when this autodetection mechanism fails, (for example, too
high of load on the machine when you start the server).  For cases like this,
one should first run the server on an unloaded machine, look at the
results of the autodetection (that are printed out during server startup)
and then explicitly specify these parameters in the configuration file.
\fBIt is recommended that all parameters, especially Clock values,
be specified in the Xconfig file.\fP
.PP
The last section is the \fBTABLE OF VIDEO MODES\fP which starts with the
keyword \fBmodedb\fP.   This is covered in the
.I Xconfig(4/5) 
manpage. For details on how to build your own video modes please refer
to the tutorial written by Eric Raymond.
.SH FILES
.TP 30
/usr/X386/bin/XF86_S3
The 8-bit color X server for S3
.TP 30
/usr/X386/bin/XF86_Mach8
The 8-bit color X server for Mach8
.TP 30
/usr/X386/bin/XF86_Mach32
The 8-bit color X server for Mach32
.TP 30
/usr/X386/bin/XF86_8514
The 8-bit color X server for IBM 8514 and true compatibles
.TP 30
/usr/X386/lib/X11/Xconfig
Server configuration file
.SH "SEE ALSO"
X(1), Xserver(1), XFree86kbd(1), XFree86(1), Xconfig(4/5), xdm(1), xinit(1)
.SH AUTHORS
.PP
In addition to the authors of \fIXFree86\fP the following people
contributed major work to this server:
.PP
.nf
Kevin Martin,    \fImartin@cs.unc.edu\fP
Jon Tombs,       \fIjon@gtex02.us.es\fP
Rik Faith,       \fIfaith@cs.unc.edu\fP
.fi
.RS 8
Did the overall work on the base accelerated servers.
.RE
.PP
.nf
David Dawes,     \fIdawes@physics.su.oz.au\fP
Dirk Hohndel,    \fIhohndel@informatik.uni-wuerzburg.de\fP
David Wexelblat, \fIdwex@goblin.org\fP, \fIdwex@aib.com\fP
.fi
.RS 8
Merged their work into XFree86.
.RE
.PP
.nf
Jon Tombs,       \fIjon@gtex02.us.es\fP
David Wexelblat, \fIdwex@goblin.org\fP, \fIdwex@aib.com\fP
David Dawes,     \fIdawes@physics.su.oz.au\fP
Amancio Hasty,   \fIhasty@netcom.com\fP
Robin Cutshaw,   \fIrobin@paros.com\fP
.fi
.RS 8
Development and improvement of the S3 specific code.
.RE
.PP
.nf
Kevin Martin,    \fImartin@cs.unc.edu\fP
Rik Faith,       \fIfaith@cs.unc.edu\fP
Tiago Gons,      \fItiago@comosjn.hobby.nl\fP
Hans Nasten,     \fInasten@everyware.se\fP
Scott Laird,     \fIlair@midway.uchicago.edu\fP
.fi
.RS 8
Development and improvement of the Mach8 and 8514/A specific code.
.RE
.PP
.nf
Kevin Martin,    \fImartin@cs.unc.edu\fP
Rik Faith,       \fIfaith@cs.unc.edu\fP
Mike Bernson,    \fImike@mbsun.mlb.org\fP
Mark Weaver,     \fIMark_Weaver@brown.edu\fP
Craig Groeschel, \fIcraig@adikia.sccsi.com\fP
.fi
.RS 8
Development and improvement of the Mach32 specific code.
.RE
.PP
See also the
.I XFree86(1)
manual page.
.SH BUGS
.PP
S3 cards with Bt485 ramdacs are currently restricted to
dot-clocks less than 85MHz.  This restriction is because the servers don't
yet support operating the ramdacs in multiplexed mode.
.SH CONTACT INFO
\fIXFree86\fP source is available from the FTP servers 
\fIftp.physics.su.oz.au\fP and \fIftp.x.org\fP.  Send email to
\fIXFree86@physics.su.oz.au\fP for details.

