 XmComboBox(Xm)			14 April 1994		     XmComboBox(Xm)

 Name

    XmComboBox - the ComboBox widget class

    Author of Software & Documentation:
	Harald Albrecht
	Institut fuer Geometrie und Praktische Mathematik
	RWTH Aachen, Bundesrepublik Deutschland
	e-mail: albrecht@igpm.rwth-aachen.de

    English Documentation:
	Chris Marotz
	Sterling Software ITD
	e-mail: marotz@itd.sterling.com

 Syntax

    #include <ComboBox.h>

 Description

    The ComboBox widget allows the user to select elements from a list of
    choices, and enter their own values in a text widget. To conserve screen
    space, the list of choices is shown only when the user selects the down 
    arrow button. The choices may then be selected from this list. The list
    will automatically by removed when the user selects an item in the list.
    When the list is removed, the item that was selected will be placed in the
    text widget. Typing the escape key when the list is up, cancels the list
    popup.

    ----------------------------
    |       -------------- --- |
    | Label | Text Field | \ / |	ComboBox Widget with list hidden.
    |       --------------  .  |
    ----------------------------


    ----------------------------
    |       --------------  .  |
    | Label | Text Field | / \ |	ComboBox Widget with list displayed.
    |       -------------- --- |
    ----------------------------
            |                | |
            |                | |
            |                | |
            | Scrolled  List | |
            |                | |
            |                | |
            |                | |
            --------------------


 XmComboBox Resource Set
 ______________________________________________________________________________
 Name                Class             Type           Default            Access
 ______________________________________________________________________________

 XmNalignment        XmCAlignment      unsigned char  XmALIGNMENT_CENTER CSG 

 XmNblinkRate        XmCBlinkRate      int            500                CSG 

 XmNcolumns          XmCColumns        short          dynamic            CSG 

 XmNcursorPosition   XmCCursorPosition XmTextPosition 0                  CSG 

 XmNcursorPositionVisible              Boolean        True               CSG 
                     XmCCursorPositionVisible 

 XmNdropDownCallback                   XtCallbackList NULL               CSG
                     XmCDropDownCallback

 XmNdropDownCursor   XmCDropDownCursor Cursor         center_ptr         CSG

 XmNdropDownOffset   XmCDropDownOffset Position       dynamic            CSG 

 XmNeditable         XmCEditable       Boolean        False              CG 

 XmNfontList         XmCFontList       XmFontList     dynamic            CSG 

 XmNitemCount        XmCItemCount      int            0                  CSG 

 XmNitems            XmCItems          XmStringTable  NULL               CSG 

 XmNlabelInsensitivePixmap             Pixmap         XmUNSPECIFIED_PIXMAP
                     XmCLabelInsensitivePixmap                           CSG 

 XmNlabelPixmap      XmCLabelPixmap    Pixmap         XmUNSPECIFIED_PIXMAP 
                                                                         CSG 

 XmNlabelString      XmCXmString       XmString       dynamic            CSG 

 XmNlabelType	     XmCLabelType      unsigned char  XmSTRING           CSG 

 XmNlabelMarginBottom XmCLabelMarginBottom            0                  CSG 
                                       Dimension

 XmNlabelMarginHeight XmCLabelMarginHeight            2                  CSG 
                                       Dimension

 XmNlabelMarginLeft   XmCLabelMarginLeft              0                  CSG 
                                       Dimension

 XmNlabelMarginRight  XmCLabelMarginRight             0                  CSG 
                                       Dimension

 XmNlabelMarginTop    XmCLabelMarginTop               0                  CSG 
                                       Dimension

 XmNlabelMarginWidth  XmCLabelMarginWidth             0                  CSG 
                                       Dimension

 XmNlabelString       XmCLabelString   XmString       "label"            CSG

 XmNlistMarginHeight  XmCListMarginHeight             0                  CSG 
                                       Dimension

 XmNlistMarginWidth   XmCListMarginWidth              0                  CSG 
                                       Dimension

 XmNlistSpacing       XmCListSpacing    Dimension     0                  CSG 

 XmNmarginHeight      XmCMarginHeight   Dimension     5                  CSG 

 XmNmarginWidth       XmCMarginWidth    Dimension     5                  CSG 

 XmNmaxLength         XmCMaxLength      int           largest integer    CSG 

 XmNpersistentDropDown                  Boolean       False              CSG 
                     XmCPersistentDropDown 

 XmNselectionCallback XmCCallback       XtCallbackList                   CSG 
                                                      NULL               

 XmNselectThreshold   XmCSelectThreshold              5                  CSG 
                                        int

 XmNshowLabel         XmCShowLabel      Boolean       False              CG 

 XmNsorted            XmCSorted         Boolean       False              CSG 

 XmNstringDirection   XmCStringDirection              dynamic            CSG 
                                        XmStringDirection

 XmNtwmHandlingOn     XmCTwmHandlingOn  Boolean       True               CSG
 XmNtopItemPostion    XmCTopItemPostion int           1                  G 

 XmNvalue             XmCValue          String        ""                 CSG 

 XmNvisibleItemCount  XmCVisibleItemCount             8                  CSG 
                                        int
 ______________________________________________________________________________
 All resource names begin with XmN and all resource class names begin with XmC.
 ______________________________________________________________________________

 XmNalignment
	The alignment (left to right) for the label's text or pixmap. Possible
	values are XmALIGNMENT_BEGINNING, XmALIGNMENT_CENTER, and
	XmALIGNMENT_END.

 XmNblinkRate
	The time in milliseconds that the cursor spends being visible or
	invisible. A value of 0 prevents the cursor from blinking.

 XmNborderWidth
	That's no new resource but is already introduced in the core class.
	This class overrides the default value and sets it to zero. You can
	however override it again if you're dissatisfied with the new default
	setting.

 XmNcolumns
	Specifies the initial width of the input field measured in character
	spaces. The default value depends on the value of the width of the
	combo box.

 XmNcursorPosition
	Indicates the position in the text where the insert cursor is to be
	located. Its position is the offset of characters and it starts with
	offset 0 at the beginning of the text.

 XmNcursorPositionVisible
	Flags whether the insert cursor position is marked by a blinking
	cursor.

 XmNdropDownCallback
        This is a list of callbacks to be called when the list is about to
        be shown or hidden. The reasons are XmCR_SHOW_LIST or XmCR_HIDE_LIST.

 XmNdropDownCursor
        Specifies the cursor to be used whenever the mouse cursor is within
        the drop down list.

 XmNdropDownOffset
	Specifies the distance between the left border of the list and the left 
	border of the input field. The default value is set to the width of the 
	arrow button. Only positive values are allowed for XmNdropDownOffset,
	negative ones will be ignored.

 XmNeditable
	Specifies the type of combo box. If set to True, the combo box contains 
	an editable input field. Therefore, the user is free to select entries
	out of the list and to enter new text or modify it. In the other case,
	with XmNeditable set to False the user can solely browse in and select
	entries out of the list.

 XmNfontList
	Indicates the font list to be used for the input field and the list. If
	the value is NULL at initialization, it is initialized by looking up
	the parent hierarchy of the widget for an ancestor that is a subclass
	of XmBulletinBoard, XmVendorShell or XmMenuShell. If such an ancestor
	is found, it's font list will be taken by the combo box widget.

 XmNitemCount
	Specifies the total number of items in the list.

 XmNitems
	Points to an array of compound strings representing the items to be
	displayed in the list. By means of this a program can find out what
	items the list contains. It is also possible to set the contents of
	the list box in one step by setting this resource to a new array of
	compound strings. Please remember: always set XmNitems and XmNitemCount
	together in the same call to XtSetValues or XtVaSetValues. If you
	ignore this rule the combo box will ignore you and your attempt to
	set these resources.

 XmNlabelInsensitivePixmap
	Specifies a pixmap used as the button face if XmNlabelType is set to
	XmPIXMAP and the combo box widget is insensitive.

 XmNlabelPixmap
	Specifies a pixmap to be displayed to the left of the input field if
	XmNlabelType is XmPIXMAP and XmNshowLabel is True (of course).

 XmNlabelString
	Specifies the the compound string to be displayed if XmNlabelType is
	set to XmSTRING and XmNshowLabel is True.

 XmNlabelType
	The type of label (either string or pixmap). Possible values are
	XmPIXMAP and XmSTRING.


 XmNlabelMarginTop, XmNlabelMarginBottom
 XmNlabelMarginLeft, XmNlabelMarginRight
	The amount of space between one side of the label and the nearest
	margin.

 XmNlabelMarginHeight
 XmNlabelMarginWidth
	The spacing between one side of the label and the nearest edge of a
	shadow.

 XmNlistMarginHeight
 XmNlistMarginWidth
	The height or width of the margin between the border of the list and
	the items in the list.

 XmNlistSpacing
	The spacing between items in the list.

 XmNmarginHeight
	Specifies the distance between the top and the bottom of the widget
	window and the text displayed in the input field.

 XmNmarginWidth
	Like XmNmarginHeight this resource specifies the distance between the
	left and the right border of the widget window and the text.

 XmNmaxLength
	Specifies the maximum length of the text string that can be entered
	from the keyboard into the input field of the combo box. Strings that
	are put into the input field using XmComboBoxSetString ignore this
	resource.

 XmNpersistentDropDown
	Welcome to the sad section in the life of X11 applications. This
	resource and the inherent problems are due to the focus policy of the
	window manager you're using. See the further details in the later
	sections.

 XmNselectionCallback
	Specifies a list of callbacks that is called when an item is selected.
	The reason is XmCR_SINGLE_SELECT. The callbacks are NOT called when 
	the user browses through the items in the list.

 XmNselectThreshold
	Specifies the amount of pixels the mouse must move until the selection
	of text is recognized in click and drag mode.

 XmNshowLabel
	Specifies, whether a label containing text or a pixmap should be
	displayed on the left side of the combo box. This resource can only be
	specified during the creation of the combo box, afterwards it will have 
	no effect.

 XmNsorted
	Specifies whether the items in the list are sorted or not. In an
	unsorted list, the items are shown in the order in which they're put
	into the list. When adding an item to a sorted list, this item will be
	put at the right place (alphabetically sorted).

 XmNstringDirection
	Specifies the initial direction to draw the string (from the left to 
	the right or in the opposite direction). The whole story seems to be
	incomprehensible... therefore this resource is provided for
	completeness only.

 XmNtwmHandlingOn
        If you have trouble with the list then this resource may help you.
        Set it to True, if the list gets hidden at the moment the mouse cursor
        enters the list.

 XmNtopItemPosition
	This resource is intended as an informal hint. It specifies the index
	of the item which is displayed at the visible top of the list.

 XmNvalue
	Contains the text of the input field. This also concerns combo boxes
	which are not editable (XmNeditable set to False).

 XmNvisibleItemCount
	Specifies the number of items that can fit in the visible space of the
	list. The combo box uses this value to determine the height of its
	list.

 ______________________________________________________________________________

 Callback Information

 A pointer to the following structure is passed to the XmNdropDownCallback
 callback:

    typedef struct {
	int      reason;
	XEvent   *event;
    } XmComboBoxDropDownCallbackStruct;

 reason
    Within this structure, "reason" indicates the reason why the callback was
    activated. This can be XmCR_SHOW_LIST or XmCR_HIDE_LIST. A callback is
    called with the reason XmCR_SHOW_LIST just before the list is dropped down.
    Whereas a callback is called with XmCR_HIDE_LIST after the list is hidden.

 event
    Points to the XEvent, which triggered the callback. May be NULL if the
    callback is triggered by a call to XmComboBoxShowList or XmComboBoxHideList.


 A pointer to the following structure is passed to the XmNselectionCallback
 callback:

    typedef struct {
	int      reason;
	XEvent   *event;
	XmString value;
	int      index;
    } XmComboBoxSelectionCallbackStruct;

 reason
    Within this structure, "reason" indicates the reason why the callback was
    activated. At this time, the only reason is XmCR_SINGLE_SELECT. It 
    indicates that the user selected a (potentially new) item in the list.

 event
    Points to the XEvent, which triggered the callback.

 value
    Points to a XmString, which contains the text of the current selected item. 
    This XmString must never be freed or changed by the called program code!

 index
    Index (starting from 1) of the currently selected item in the list.
 ______________________________________________________________________________


 Convenience Routines
    ComboBox has a number of convenience routines to control the behavior and
    contents of its children.

 void XmComboBoxAddItem(Widget w, XmString item, int pos)
    Add a new item to the list's contents. If XmNsorted is set to True, the new 
    item is inserted alphabetically. If the list is unsorted, the same
    assumptions can be applied as with XmListAddItem.

 void XmComboBoxAddItems(Widget w, XmString *items, int item_count, int pos)
    Similar to XmComboBoxAddItem. Also see XmListAddItems.

 void XmComboBoxAddItemUnselected(Widget w, XmString item, int pos)
    See XmListAddItemUnselected.

 void XmComboBoxDeleteItem(Widget w, XmString item)
    See XmListDeleteItem.

 void XmComboBoxDeleteItems(Widget w, XmString *items, int item_count)
    See XmListDeleteItems.

 void XmComboBoxDeletePos(Widget w, int pos)
    See XmListDeletePos.

 void XmComboBoxDeleteItemsPos(Widget w, int item_count, int pos)
    See XmListDeleteItemsPos.

 void XmComboBoxDeleteAllItems(Widget w)
    See XmListDeleteAllItems.

 void XmComboBoxReplaceItems(Widget w, XmString *old_items, int item_count,
                             XmString *new_items)
    See XmListReplaceItems.

 void XmComboBoxReplaceItemsPos(Widget w, XmString *new_items, int item_count,
                                int position)
    See XmListReplaceItemsPos.

 Boolean XmComboBoxItemExists(Widget w, XmString item)
    See XmListItemExists.

 int XmComboBoxItemPos(Widget w, XmString item)
    See XmListItemPos.

 Boolean XmComboBoxGetMatchPos(Widget w, XmString item, int **pos_list,
                               int *pos_count)
    See XmListGetMatchPos.

 void XmComboBoxSelectPos(Widget w, int pos, Boolean notify)
    See XmListSelectPos.

 void XmComboBoxSelectItem(Widget w, XmString item, Boolean notify)
    See XmListSelectItem

 int XmComboBoxGetSelectedPos(Widget w)
    This function differs from XmListGetSelectedPos. The list in a combo box
    can contain only one selected item. Therefore this function returns the
    index of the selected item in the list or zero, if none is currently
    selected.

 void XmComboBoxClearSelection(Widget w, Time time)
    See XmTextFieldClearSelection.

 Boolean XmComboBoxCopy(Widget w, Time time)
    See XmTextFieldCopy.

 Boolean XmComboBoxCut(Widget w, Time time)
    See XmTextFieldCut.

 XmTextPosition XmComboBoxGetInsertionPosition(Widget w)
    See XmTextFieldGetInsertionPosition.

 XmTextPosition XmComboBoxGetLastPosition(Widget w)
    See XmTextFieldGetLastPosition.

 int XmComboBoxGetMaxLength(Widget w)
    See &XmTextFieldGetMaxLength.

 char *XmComboBoxGetSelection(Widget w)
    See XmTextFieldGetSelection.

 Boolean XmComboBoxGetSelectionPosition(Widget w, XmTextPosition *left,
                                        XmTextPosition *right)
    See XmTextFieldGetSelectionPosition.

 char *XmComboBoxGetString(Widget w)
    See XmTextFieldGetString.

 void XmComboBoxInsert(Widget w, XmTextPosition position, char *value)
    See XmTextFieldInsert.

 Boolean XmComboBoxPaste(Widget w)
    See XmTextFieldPaste.

 Boolean XmComboBoxRemove(Widget w)
    See XmTextFieldRemove.

 void XmComboBoxReplace(Widget w, XmTextPosition from_pos,
                        XmTextPosition to_pos, char *value)
    See XmTextFieldReplace.

 void XmComboBoxSetAddMode(Widget w, Boolean state)
    See XmTextFieldSetAddMode.

 void XmComboBoxSetHighlight(Widget w, XmTextPosition left, 
                             XmTextPosition right, XmHighlightMode mode)
    See XmTextFieldSetHighlight.

 void XmComboBoxSetInsertionPosition(Widget w, XmTextPosition position)
    See XmTextFieldSetInsertionPosition.

 void XmComboBoxSetMaxLength(Widget w, int max_length)
    See XmTextFieldSetMaxLength.

 void XmComboBoxSetSelection(Widget w, XmTextPosition first,
                             XmTextPosition last, Time time)
    See XmTextFieldSetSelection.

 void XmComboBoxSetString(Widget w, char *value)
    At least Motif~1.1 contains a very anoying bug. If you try to set the
    contents of an XmTextField to an empty string (""), you'll get garbage,
    when asking the XmTextField for its contents afterwards. This interface
    function provides a work around. Also see XmTextFieldSetString.

 void XmComboBoxShowPosition(Widget w, XmTextPosition position)
    See XmTextFieldShowPosition.
 ------------------------------------------------------------------------------

 The disliked keyboard focus

    Now I'll annotate a somewhat tricky subject. If the resource 
    XmNpersistentDropDown defaults to its initial value of False, one can
    observe the following effect (this may be annoying).

    When the user drops down the list and then moves the mouse cursor out of
    the window where the combo box resides in, the list will be hidden. This is
    because the widget lost the keyboard focus. Some users are irritated 
    because they didn't expect that behavior, because they just moved the mouse
    to get it out of the way. If your window manager's focus policy is "pointer
    focus", i.e.  if you move the pointer into another window, that window will 
    automatically get the keyboard focus. On the other hand, if your window
    manager's focus policy is "explicit", you have to move the pointer into
    another window and click a mouse button to give that window the keyboard
    focus. This is often referred to as the "click-to-type" method. In 
    "explicit" mode, you will never see the list's annoying behavior.

    To bypass this behavior on some window managers a really dirty hack was
    used. The user can activate that hack, if he sets XmNpersistentDropDown to
    True in the application's resources. Sorry, on some window managers this 
    will not fix the annoying behavior.

    Try it if you like -- but don't complain at me if it doesn't work as
    expected. But at least it worked on the author's machine: a cute little SGI 
    Indigo running 4dwm as the window manager.

    On some other window managers like twm you will face another problem: the
    list gets hidden as soon as the mouse cursor enters the list. Try to set
    XmNtwmHandlingOn to True. This resource will also work with other window
    managers.

 ______________________________________________________________________________


 Creating a combo box

    Using the combo box in your own programs is easy. Just create the widget
    with one of the innumerable X toolkit functions (like XtCreateManagedWidget
    or XtVaCreateManagedWidget).

    Specify as the widget class xmComboBoxWidgetClass -- that's all. There are
    no so-called creation convenience functions, since there isn't any need for 
    them.

    Somewhere in your program you'll need something like the following code
    fragment:

	....
	Widget ComboBox;

	ComboBox = XtVaCreateManagedWidget("combobox",
			xmComboBoxWidgetClass, Parent,
			XmNeditable, True or False,
        		other Resources...
        		NULL);

    Setting the resource XmNeditable is not absolutely necessary, but it's
    better to do so.

    After creation, items can be added to the combo box's list by means of
    interface functions like XmComboBoxAddItem. Which item the user selected
    can be determined by calling XmComboBoxGetString.

    If you want to preselect an item (that is setting a default item to the
    input field of the combo box) you can use several convenience functions.
    On a combo box with a non editable input field there are two ways to
    select an item:

        ....
        XmComboBoxSelectPos(ComboBox, item #, False);

    or:

        ....
        XmComboBoxSelectItem(ComboBox, itemString, False);

    The third parameter in these two function calls indicates whether the
    XmNselectionCallback should be called. The only difference between
    these functions is the first one is expecting an item number whereas the
    second one expects a XmString. The list is then searched for this
    string and if it is found the input field will be updated.
    
    On a combo box with XmNeditable set to True use another function:
    
        ....
	XmComboBoxSetString(ComboBox, string);
	
    This sets the contents of the text input field to string.

 ------------------------------------------------------------------------------

 Where it is running successfully

 Below a list of all configurations, where the combo box widget is known to 
 work. At the time, this is terrifyingly short but it's constantly growing.

    DEC: DECstation 5000/240: ULTRIX 4.3 with Motif 1.1
         VAX: VMS5.5-2 with Motif 1.1
    IBM: RS6000 & AIX 3.2 with Motif 1.1, 1.2
    PC: SCO Unix with Motif 1.1
    Silicon Graphics: IRIS Indigo: IRIX 4.0.5 with Motif 1.1
    HP: 700's: HPUX 9.0.x with Motif 1.2
    Sun: Sparc: SunOS 4.1.x with Motif 1.1, 1.2

 ______________________________________________________________________________
 Inherited resources

    ComboBox inherits behavior and resources from the following superclasses.
    For a complete description of each resource, refer to the man page for that 
    superclass.

 Core default resource set
 ____________________________________________________________________________
 Name                Class               Type           Default        Access
 ____________________________________________________________________________

 XmNaccelerators     XmCAccelerators     XtAccelerators dynamic        CSG

 XmNancestorSensitive                    Boolean        dynamic        G
                     XmCSensitive

 XmNbackground       XmCBackground       Pixel          dynamic        CSG

 XmNbackgroundPixmap XmCPixmap           Pixmap         XmUNSPECIFIED_PIXMAP
                                                                       CSG

 XmNborderColor      XmCBorderColor      Pixel          XtDefaultForeground
                                                                       CSG

 XmNborderPixmap     XmCPixmap           Pixmap         XmUNSPECIFIED_PIXMAP
                                                                       CSG

 XmNborderWidth      XmCBorderWidth      Dimension      1              CSG

 XmNcolormap         XmCColormap         Colormap       dynamic        CG

 XmNdepth            XmCDepth            int            dynamic        CG

 XmNdestroyCallback  XmCCallback         XtCallbackList NULL           C

 XmNheight           XmCHeight           Dimension      dynamic        CSG

 XmNinitialResourcesPersistent           Boolean        True           C
                     XmCInitialResourcesPersistent          

 XmNmappedWhenManaged                    Boolean        True           CSG
                     XmCMappedWhenManaged

 XmNscreen           XmCScreen           Screen *       dynamic        CG

 XmNsensitive        XmCSensitive        Boolean        True           CSG

 XmNtranslations     XmCTranslations     XtTranslations dynamic        CSG

 XmNwidth            XmCWidth            Dimension      dynamic        CSG

 XmNx                XmCPosition         Position       0              CSG

 XmNy                XmCPosition         Position       0              CSG
 ______________________________________________________________________________

 XmLabel default resource set
 ______________________________________________________________________________
 Name              Class             Type             Default            Access
 ______________________________________________________________________________
 XmNaccelerator    XmCAccelerator    String           NULL               CSG

 XmNacceleratorText                  XmString         NULL               CSG
		   XmCAcceleratorText

 XmNalignment      XmCAlignment      unsigned char    dynamic            CSG

 XmNfontList       XmCFontList       XmFontList       dynamic            CSG

 XmNlabelInsens-   XmCLabelInsens-   Pixmap           XmUNSPECIFIED_PIXMAP
 itivePixmap       itivePixmap                                           CSG

 XmNlabelPixmap    XmCLabelPixmap    Pixmap           XmUNSPECIFIED_PIXMAP
                                                                         CSG

 XmNlabelString    XmCXmString       XmString         dynamic            CSG

 XmNlabelType      XmCLabelType      unsigned char    XmSTRING           CSG

 XmNmarginBottom   XmCMarginBottom   Dimension        0                  CSG

 XmNmarginHeight   XmCMarginHeight   Dimension        2                  CSG

 XmNmarginLeft     XmCMarginLeft     Dimension        0                  CSG

 XmNmarginRight    XmCMarginRight    Dimension        0                  CSG

 XmNmarginTop      XmCMarginTop      Dimension        0                  CSG

 XmNmarginWidth    XmCMarginWidth    Dimension        2                  CSG

 XmNmnemonic       XmCMnemonic       KeySym           NULL               CSG

 XmNmnemonicCharSet                  String           dynamic            CSG
                   XmCMnemonicCharSet

 XmNrecomputeSize  XmCRecomputeSize  Boolean          True               CSG

 XmNstringDirection                  XmStringDirection                   CSG
                   XmCStringDirection                 dynamic
 ______________________________________________________________________________


 XmList default resource set
 _____________________________________________________________________________
 Name                Class                 Type             Default    Access
 _____________________________________________________________________________
 XmNautomatic-       XmCAutomaticSelection Boolean          False      CSG
 Selection

 XmNbrowseSelection- XmCCallback           XtCallbackList   NULL       C
 Callback

 XmNdefaultAction-   XmCCallback           XtCallbackList   NULL       C
 Callback

 XmNdoubleClick-     XmCDoubleClickIntervalint              dynamic    CSG
 Interval

 XmNextended-        XmCCallback           XtCallbackList   NULL       C
 SelectionCallback

 XmNfontList         XmCFontList           XmFontList       dynamic    CSG

 XmNitemCount        XmCItemCount          int              0          CSG

 XmNitems            XmCItems              XmStringTable    NULL       CSG

 XmNlistMarginHeight XmCListMarginHeight   Dimension        0          CSG

 XmNlistMarginWidth  XmCListMarginWidth    Dimension        0          CSG

 XmNlistSizePolicy   XmCListSizePolicy     unsigned char    XmVARIABLE CG

 XmNlistSpacing      XmCListSpacing        Dimension        0          CSG

 XmNmultiple-        XmCCallback           XtCallbackList   NULL       C
 SelectionCallback

 XmNscrollBarDisplay-XmCScrollBarDisplay-  unsigned char    XmAS_NEEDEDCSG
 Policy              Policy

 XmNselectedItemCountXmCSelectedItemCount  int              0          CSG

 XmNselectedItems    XmCSelectedItems      XmStringTable    NULL       CSG

 XmNselectionPolicy  XmCSelectionPolicy    unsigned char    XmBROWSE_- CSG
                                                            SELECT

 XmNsingleSelection- XmCCallback           XtCallbackList   NULL       C
 Callback

 XmNstringDirection  XmCStringDirection    XmStringDirectiondynamic    CSG

 XmNtopItemPosition  XmCTopItemPosition    int              1          CSG

 XmNvisibleItemCount XmCVisibleItemCount   int              1          CSG
 ------------------------------------------------------------------------------


 XmArrowButton default resource set
 ____________________________________________________________________________
 Name                 Class               Type            Default      Access
 ____________________________________________________________________________
 XmNactivateCallback  XmCCallback         XtCallbackList  NULL         C

 XmNarmCallback       XmCCallback         XtCallbackList  NULL         C

 XmNarrowDirection    XmCArrowDirection   unsigned char   XmARROW_UP   CSG

 XmNdisarmCallback    XmCCallback         XtCallbackList  NULL         C

 XmNmultiClick        XmCMultiClick       unsigned char   dynamic      CSG

