/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);
    QString path = qgetenv("PATH");
    QString in = qgetenv("IN");

    {
        // Test import Weboob
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.load()"), document1.load(SKGTest::getTestPath(QStringLiteral("IN")) % "/skgtestimportbackend/fake1/fake1.skg"), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/fake1/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTESTERROR(QStringLiteral("WEBOOB.importFile"), imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR(QStringLiteral("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QStringLiteral("v_account"), QStringLiteral("12345"), account), true);
            SKGTESTERROR(QStringLiteral("ACCOUNT.load"), account.load(), true);
            SKGTEST(QStringLiteral("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QStringLiteral("1523.99"));
            SKGTEST(QStringLiteral("ACCOUNT:getAmount"), SKGServices::doubleToString(account.getAmount(QDate(2013, 5, 1))), QStringLiteral("1471.22"));

            SKGTESTERROR(QStringLiteral("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QStringLiteral("v_account"), QStringLiteral("47896"), account), true);
            SKGTESTERROR(QStringLiteral("ACCOUNT.load"), account.load(), true);
            SKGTEST(QStringLiteral("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QStringLiteral("-30"));
            SKGTEST(QStringLiteral("ACCOUNT:getAmount"), SKGServices::doubleToString(account.getAmount(QDate(2013, 5, 1))), QStringLiteral("0"));

            SKGObjectBase::SKGListSKGObjectBase result;
            SKGTESTERROR(QStringLiteral("DOC.getObjects"), document1.getObjects(QStringLiteral("v_operation"), QStringLiteral("t_comment='SNCF'"), result), true);
            SKGTEST(QStringLiteral("DOC.getObjects.count"), result.count(), 2);

            SKGTESTERROR(QStringLiteral("DOC.getObjects"), document1.getObjects(QStringLiteral("v_operation"), QStringLiteral("d_date='2013-05-26'"), result), true);
            SKGTEST(QStringLiteral("DOC.getObjects.count"), result.count(), 1);
        }
    }

    {
        // BUG: 320716
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.320716_1", qputenv("PATH", (in + "/skgtestimportbackend/320716_1/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTESTERROR(QStringLiteral("WEBOOB.importFile"), imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR(QStringLiteral("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QStringLiteral("v_account"), QStringLiteral("12345"), account), true);
            SKGTESTERROR(QStringLiteral("ACCOUNT.load"), account.load(), true);
            SKGTEST(QStringLiteral("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QStringLiteral("100"));
        }

        {
            SKGTESTBOOL("PUTENV.320716_1", qputenv("PATH", (in + "/skgtestimportbackend/320716_2/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTESTERROR(QStringLiteral("WEBOOB.importFile"), imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR(QStringLiteral("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QStringLiteral("v_account"), QStringLiteral("12345"), account), true);
            SKGTESTERROR(QStringLiteral("ACCOUNT.load"), account.load(), true);
            SKGTEST(QStringLiteral("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QStringLiteral("0"));
        }
    }

    {
        // Test error
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/error1/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTEST(QStringLiteral("WEBOOB.importFile"), imp1.importFile().getReturnCode(), ERR_FAIL);
        }
    }

    {
        // Test error
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/error2/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTEST(QStringLiteral("WEBOOB.importFile"), imp1.importFile().getReturnCode(), ERR_FAIL);
        }
    }

    {
        // Test error
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/error3/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            document1.sendMessage(QStringLiteral("Hello"));

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTEST(QStringLiteral("WEBOOB.importFile"), imp1.importFile().getReturnCode(), ERR_FAIL);
        }
    }

    {
        // Test error
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.fake1", qputenv("PATH", (in + "/skgtestimportbackend/error4/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTEST(QStringLiteral("WEBOOB.importFile"), imp1.importFile().getReturnCode(), ERR_FAIL);
        }
    }

    {
        // BUG: 329876
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.329876", qputenv("PATH", (in + "/skgtestimportbackend/329876/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob0g")));
            SKGTESTERROR(QStringLiteral("WEBOOB.importFile"), imp1.importFile(), true);
        }

        // Check
        {
            SKGObjectBase::SKGListSKGObjectBase ops;
            SKGTESTERROR(QStringLiteral("DOC.getObjectByName"), document1.getObjects(QStringLiteral("v_operation"), QStringLiteral("d_date='2014-01-05'"), ops), true);
            SKGTEST(QStringLiteral("DOC.getObjectByName"), static_cast<unsigned int>(ops.count()), static_cast<unsigned int>(3));
        }
    }

    {
        // BUG: weboob0h
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            SKGTESTBOOL("PUTENV.weboob0h", qputenv("PATH", (in + "/skgtestimportbackend/weboob0h/:" + path).toLatin1()), true);

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob0g")));
            SKGTESTERROR(QStringLiteral("WEBOOB.importFile"), imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR(QStringLiteral("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QStringLiteral("v_account"), QStringLiteral("1234"), account), true);
            SKGTESTERROR(QStringLiteral("ACCOUNT.load"), account.load(), true);
            SKGTEST(QStringLiteral("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QStringLiteral("-147994.82"));
        }
    }

    {
        // Better account selection
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("CREATE ACCOUNT"), err);

            // Creation the bank
            SKGBankObject bank(&document1);
            SKGTESTERROR(QStringLiteral("BANK.setName"), bank.setName(QStringLiteral("caisse-epargne")), true);
            SKGTESTERROR(QStringLiteral("BANK.setNumber"), bank.setNumber(QStringLiteral("13135")), true)
            SKGTESTERROR(QStringLiteral("BANK.save"), bank.save(), true)

            // Creation the account
            SKGAccountObject account;
            SKGTESTERROR(QStringLiteral("BANK.addAccount"), bank.addAccount(account), true)
            SKGTESTERROR(QStringLiteral("ACCOUNT.setName"), account.setName(QStringLiteral("test")), true)
            SKGTESTERROR(QStringLiteral("ACCOUNT.setNumber"), account.setNumber(QStringLiteral("123456789")), true)
            SKGTESTERROR(QStringLiteral("ACCOUNT.setAgencyNumber"), account.setAgencyNumber(QStringLiteral("00080")), true)
            SKGTESTERROR(QStringLiteral("ACCOUNT.save"), account.save(), true)
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGTESTBOOL("PUTENV.weboob", qputenv("PATH", (in + "/skgtestimportbackend/betterselection/:" + path).toLatin1()), true);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTESTERROR(QStringLiteral("WEBOOB.importFile"), imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR(QStringLiteral("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QStringLiteral("v_account"), QStringLiteral("test"), account), true);
            SKGTESTERROR(QStringLiteral("ACCOUNT.load"), account.load(), true);
            SKGTEST(QStringLiteral("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QStringLiteral("-147994.82"));
        }
    }


    {
        // Better account selection
        SKGDocumentBank document1;
        SKGTESTERROR(QStringLiteral("document1.initialize()"), document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QStringLiteral("IMPORT_WEBOOB"), err);

            SKGTESTBOOL("PUTENV.weboob", qputenv("PATH", (in + "/skgtestimportbackend/joint_accounts/:" + path).toLatin1()), true);

            SKGImportExportManager imp1(&document1, QUrl(QStringLiteral(".weboob")));
            SKGTESTERROR(QStringLiteral("WEBOOB.importFile"), imp1.importFile(), true);
        }

        // Check
        {
            SKGAccountObject account;
            SKGTESTERROR(QStringLiteral("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QStringLiteral("v_account"), QStringLiteral("12345"), account), true);
            SKGTESTERROR(QStringLiteral("ACCOUNT.load"), account.load(), true);
            SKGTEST(QStringLiteral("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QStringLiteral("1000"));
        }
    }
    // End test
    SKGENDTEST();
}
