/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true) {
        // Test import 304313
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy/304313.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }
    }

    {
        // Test import SKG
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_SKG"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/advice.skg"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }

        {
            // Scope of the transaction
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtestimportkmy3/advice.kmy"));
            SKGTESTERROR(QLatin1String("KMY.exportFile"), imp1.exportFile(), true)
        }
    }

    {
        // Test import wallet
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy3/wallet.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("KMY.setName"), account.setName(QLatin1String("Espece")), true)
            SKGTESTERROR(QLatin1String("KMY.load"), account.load(), true)
            SKGBankObject bank;
            SKGTESTERROR(QLatin1String("KMY.load"), account.getBank(bank), true)
            SKGTEST(QLatin1String("KMY:getName"), bank.getName(), QLatin1String(""))
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("KMY.setName"), account.setName(QLatin1String("Courant")), true)
            SKGTESTERROR(QLatin1String("KMY.load"), account.load(), true)
            SKGBankObject bank;
            SKGTESTERROR(QLatin1String("KMY.load"), account.getBank(bank), true)
            SKGTEST(QLatin1String("KMY:getName"), bank.getName(), QLatin1String("KMYMONEY"))
        }
    }
    // End test
    SKGENDTEST()
}
