/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test for actions.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestactions.h"
#include "skgboardwidget.h"
#include "skgdocumentbank.h"
#include "skgmainpanel.h"
#include "skgtestmacro.h"
#include "skgtraces.h"
#include <utility>

void SKGTESTActions::Test()
{
    KLocalizedString::setApplicationDomain("skrooge");

    // Initialize document
    SKGDocumentBank doc;

    // Create main panel
    SKGMainPanel mainpanel(nullptr, &doc);
    mainpanel.show();

    QVERIFY2(!doc.load(SKGTest::getTestPath(QLatin1String("IN")) % "/advice.skg"), "Load document failed");

    {
        SKGError err;
        SKGBEGINTRANSACTION(doc, QLatin1String("DELETE"), err)
        doc.executeSqliteOrder(QLatin1String("DELETE FROM operation WHERE d_date<'") + SKGServices::dateToSqlString(QDate::currentDate().addMonths(-2)) + '\'');
    }

    // Scenario
    QStringList actionsToExecute;
    actionsToExecute
    // Reinitialize document
            << QLatin1String("tab_closeall") << QLatin1String("fullscreen") << QLatin1String("fullscreen") << QLatin1String("fullscreen") << QLatin1String("edit_undolastsave") << QLatin1String("view_unlock") << QLatin1String("view_unlock") << QLatin1String("options_show_menubar") << QLatin1String("options_show_menubar")
            // Bank page
            << QLatin1String("page_Skrooge bank plugin") << QLatin1String("enable_editor") << QLatin1String("edit_select_all") << QLatin1String("edit_copy") << QLatin1String("edit_switch_highlight") << QLatin1String("edit_select_all") << QLatin1String("edit_delete")
            // Undo
            << QLatin1String("edit_undo") << QLatin1String("edit_redo") << QLatin1String("edit_undolastsave") << QLatin1String("edit_clear_history")
            // Clean
            << QLatin1String("edit_select_all") << QLatin1String("open_report") << QLatin1String("edit_find")
            << QLatin1String("page_Skrooge bank plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_reconcile")
            << QLatin1String("page_Skrooge bank plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_find")

            // Transaction
            << QLatin1String("page_Skrooge operation plugin") << QLatin1String("enable_editor") << QLatin1String("fast_edition") << QLatin1String("edit_select_all") << QLatin1String("edit_switch_highlight") << QLatin1String("edit_mark_selected_operation")
            << QLatin1String("merge_sub_operations")
            // Too long << "edit_select_all" << "edit_duplicate_operation"
            << QLatin1String("edit_select_all") << QLatin1String("edit_group_operation") << QLatin1String("merge_imported_operation")
            << QLatin1String("edit_select_all") << QLatin1String("open_report")
            << QLatin1String("page_Skrooge operation plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_find")

            // Category
            << QLatin1String("page_Skrooge categories plugin") << QLatin1String("edit_expandall") << QLatin1String("edit_collapseal")
            << QLatin1String("edit_select_all") << QLatin1String("open_report")
            << QLatin1String("page_Skrooge categories plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_find")

            // Search page
            << QLatin1String("page_Skrooge search plugin") << QLatin1String("edit_select_all")
            << QLatin1String("execute_all") << QLatin1String("execute_notchecked") << QLatin1String("execute_imported") << QLatin1String("execute_not_validated")
            << QLatin1String("open_report")

            // All other pages
            << QLatin1String("page_Dashboard plugin") << QLatin1String("500")
            << QLatin1String("page_Skrooge budget plugin") << QLatin1String("tool_process_budget_rules") << QLatin1String("edit_select_all") << QLatin1String("open_report")
            << QLatin1String("page_Skrooge budget plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_find")
            << QLatin1String("page_Skrooge calculator plugin")
            << QLatin1String("page_Skrooge payee plugin") << QLatin1String("edit_select_all") << QLatin1String("open_report")
            << QLatin1String("page_Skrooge payee plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_find")
            << QLatin1String("page_Skrooge report plugin")
            << QLatin1String("page_Skrooge scheduled plugin") << QLatin1String("edit_select_all") << QLatin1String("open_report")
            << QLatin1String("page_Skrooge scheduled plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_find")
            << QLatin1String("page_Skrooge tracker plugin") << QLatin1String("edit_select_all") << QLatin1String("open_report")
            << QLatin1String("page_Skrooge tracker plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_find")
            << QLatin1String("page_Skrooge unit plugin") << QLatin1String("edit_select_all") << QLatin1String("open_report")
            << QLatin1String("page_Skrooge unit plugin") << QLatin1String("edit_select_all") << QLatin1String("edit_find")

            // Go
            << QLatin1String("page_Monthly plugin") << QLatin1String("go_previous") << QLatin1String("go_next") << QLatin1String("go_home") << QLatin1String("new_tab")

            // imports
            << QLatin1String("import") << QLatin1String("import_backends") << QLatin1String("import_standard_bookmarks") << QLatin1String("import_standard_categories")

            // Processing
            << QLatin1String("align_comment") << QLatin1String("clean_delete_unused_categories") << QLatin1String("clean_delete_unused_payees") << QLatin1String("clean_delete_unused_units") << QLatin1String("clean_remove_group_with_one_operation")
            << QLatin1String("process_banks") << QLatin1String("process_foundtransfer") << QLatin1String("process_validate") << QLatin1String("processing") << QLatin1String("switch_validation_imported_operation")

            // Views
            << QLatin1String("view_bookmarks") << QLatin1String("view_context") << QLatin1String("view_contextmenu") << QLatin1String("view_lock") << QLatin1String("view_menu") << QLatin1String("view_open_duplicates") << QLatin1String("view_open_highlight")
            << QLatin1String("view_open_last_modified") << QLatin1String("view_open_not_validated") << QLatin1String("view_open_operation_in_group_of_one") << QLatin1String("view_open_operation_with_comment_not_aligned")
            << QLatin1String("view_open_operation_without_category") << QLatin1String("view_open_operation_without_mode") << QLatin1String("view_open_operation_without_payee") << QLatin1String("view_open_suboperations")
            << QLatin1String("view_open_transfers_without_category") << QLatin1String("view_open_transfers_without_payee") << QLatin1String("view_open_very_old_operations") << QLatin1String("view_properties") << QLatin1String("view_transactions")
            // Close
            << QLatin1String("tab_close") << QLatin1String("tab_closeallother") << QLatin1String("tab_closeall")
            // Tabs
            << QLatin1String("tab_reopenlastclosed") << QLatin1String("tab_resetdefaultstate") << QLatin1String("tab_savedefaultstate") << QLatin1String("tab_switchpin") << QLatin1String("tab_overwritebookmark")

            // File
            << QLatin1String("file_save") << QLatin1String("file_new");

    // Dump actions
    QMap< QString, QPointer<QAction> > actions = mainpanel.getGlobalActions();
    QStringList keys = actions.keys();
    for (const auto& key : std::as_const(keys)) {
        if (!actionsToExecute.contains(key)) {
            SKGTRACE << "  [" << key << "]" << Qt::endl;
        }
    }

    // Trigger actions
    for (const auto& key : std::as_const(actionsToExecute)) {
        if (key == QLatin1String("edit_select_all")) {
            SKGTRACE << "      Wait" << Qt::endl;
            QTest::qWait(10);
        }
        SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyy-MM-dd hh:mm:ss")) << "  [" << key << "]: ";
        QAction* act = mainpanel.getGlobalAction(key);
        if (act != nullptr) {
            act->trigger();
            SKGTRACESUITE << "DONE" << Qt::endl;
        } else {
            SKGTRACESUITE << "UNKNOWN" << Qt::endl;
        }

        if (key == QLatin1String("edit_select_all")) {
            SKGTabPage* page = mainpanel.currentPage();
            if (page != nullptr) {
                SKGTRACE << "      Current page:" << page->objectName() << Qt::endl;
            }
            SKGTRACE << "      Nb objects selected:" << mainpanel.getNbSelectedObjects() << Qt::endl;
        }
    }
}

QTEST_MAIN(SKGTESTActions)

