<?php
/**
 * The Turba_ObjectView:: class provides an interface for visualizing
 * a Turba_AbstractObject.
 *
 * $Horde: turba/lib/ObjectView.php,v 1.14 2003/03/28 19:28:50 chuck Exp $
 *
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @version  $Revision: 1.14 $
 * @since Turba 0.0.1
 * @package turba
 */
class Turba_ObjectView {

	/**
     * The object that this Turba_ObjectView displays.
     * @var	Turba_AbstractObject
     */
    var $object;

    /**
     * The template used to display the object.
     * @var string
     */
    var $template;

    /**
     * Constructs a new Turba_ObjectView object.
     *
     * @param $object   The object to display.
     * @param $template What template file to display this object with.
     */
    function Turba_ObjectView(&$object, $template = null)
    {
        $this->object = &$object;
        $this->template = $template;
    }

    /**
     * Set up the Horde_Form variables based on $attributes.
     */
    function setFormVariables(&$formobject)
    {
        require TURBA_BASE . '/config/attributes.php';

        $fields = array_keys($this->object->source->getCriteria());
        foreach ($fields as $field_name) {
            if (!isset($attributes[$field_name])) {
                continue;
            }
            $field = $attributes[$field_name];
            $field_params = isset($field['params']) ? $field['params'] : array();
            $readonly = isset($field['readonly']) ? $field['readonly'] : null;
            $desc = isset($field['desc']) ? $field['desc'] : null;

            $formobject->addVariable($field['label'], 'object[' . $field_name . ']', $field['type'], $field['required'], $readonly, $desc, $field_params);
        }
    }

    /**
     * Renders the object into an HTML view.
     */
    function display()
    {
        require TURBA_BASE . '/config/attributes.php';
        $fields = $this->object->source->getCriteria();
        require $this->template;
    }

}
