<?php
/**
 * Class for providing a generic UI for any VFS instance.
 *
 * $Horde: horde/lib/VFS/Browser.php,v 1.5 2003/07/01 13:20:32 chuck Exp $
 *
 * Copyright 2002-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.5 $
 * @since   Horde 2.2
 * @package horde.vfs
 */
class VFS_Browser {

    /**
     * The VFS instance that we are browsing.
     * @var object VFS $_vfs
     */
    var $_vfs;

    /**
     * The directory where the templates to use are.
     * @var string $_templates
     */
    var $_templates;

    function VFS_Browser(&$vfs, $templates)
    {
        if (isset($vfs)) {
            $this->_vfs = $vfs;
        }
        $this->_templates = $templates;
    }

    function setVFSObject(&$vfs)
    {
        $this->_vfs = &$vfs;
    }

    function getUI($path, $dotfiles = false, $dironly = false)
    {
        $this->_vfs->listFolder($path, $dotfiles, $dironly);
    }

}
