<?php
/**
 * Kronolith base inclusion file.
 *
 * $Horde: kronolith/lib/base.php,v 1.86 2003/06/24 11:39:31 jan Exp $
 *
 * This file brings in all of the dependencies that every Kronolith
 * script will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde.
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Kronolith.
@define('KRONOLITH_BASE', dirname(__FILE__) . '/..');

// Browser detection library.
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &Browser::singleton();

// Registry.
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$success = $registry->pushApp('kronolith');
$conf = &$GLOBALS['conf'];
@define('KRONOLITH_TEMPLATES', $registry->getParam('templates'));

if (is_a($success, 'PEAR_Error')) {
    Horde::fatal($success, __FILE__, __LINE__);
}

// Horde base libraries.
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Image.php';
require_once HORDE_BASE . '/lib/Data.php';

// Notification system.
require_once HORDE_BASE . '/lib/Notification.php';
require_once KRONOLITH_BASE . '/lib/Notification/Listener/status.php';
$notification = &Notification::singleton();
$notification->attach('status', null, 'Notification_Listener_status_kronolith');
// Kronolith base library.
require_once KRONOLITH_BASE . '/lib/Kronolith.php';

// Don't allow access unless there is a Horde login or we are just
// displaying free/busy information.
if (!Auth::isAuthenticated() &&
    !$registry->allowGuests() &&
    !Kronolith::isFreeBusyUrl()) {
    Horde::authenticationFailureRedirect();
}

// Help.
require_once HORDE_BASE . '/lib/Help.php';

// PEAR Date_Calc
require_once 'Date/Calc.php';

// Start compression, if requested.
Horde::compressOutput();

// Set the timezone variable, if available.
NLS::setTimeZone();

// Make sure a session exists.
if (!array_key_exists('kronolith', $_SESSION)) {
    $_SESSION['kronolith'] = array();
}

// Create a share instance.
require_once HORDE_BASE . '/lib/Share.php';
$GLOBALS['shares'] = &Horde_Share::singleton($registry->getApp());

// Update the preference for what calendars to display. If the user
// doesn't have any selected calendars for view then fall back to some
// available calendar.
$GLOBALS['display_calendars'] = unserialize($GLOBALS['prefs']->getValue('display_cals'));
$GLOBALS['display_remote_calendars'] = unserialize($GLOBALS['prefs']->getValue('display_remote_cals'));
if (($d_cal = Horde::getFormData('display_cal')) !== null) {
    if (substr($d_cal, 0, 7) == 'remote_') {
        $d_cal = urldecode(substr($d_cal, 7));
        if (in_array($d_cal, $GLOBALS['display_remote_calendars'])) {
            $key = array_search($d_cal, $GLOBALS['display_remote_calendars']);
            unset($GLOBALS['display_remote_calendars'][$key]);
        } else {
            $GLOBALS['display_remote_calendars'][] = $d_cal;
        }
    } else {
        if (in_array($d_cal, $GLOBALS['display_calendars'])) {
            $key = array_search($d_cal, $GLOBALS['display_calendars']);
            unset($GLOBALS['display_calendars'][$key]);
        } else {
            $GLOBALS['display_calendars'][] = $d_cal;
        }
    }
}

// Make sure all shares exists now to save on checking later.
$_temp = $GLOBALS['display_calendars'];
$_all = Kronolith::listCalendars();
$GLOBALS['display_calendars'] = array();
foreach ($_temp as $id) {
    if (isset($_all[$id])) {
        $GLOBALS['display_calendars'][] = $id;
    }
}
$GLOBALS['prefs']->setValue('display_cals', serialize($GLOBALS['display_calendars']));

// Make sure all the remote calendars still exist.
$_temp = $GLOBALS['display_remote_calendars'];
$_all = unserialize($GLOBALS['prefs']->getValue('remote_cals'));
$GLOBALS['display_remote_calendars'] = array();
foreach ($_all as $id) {
    if (in_array($id['url'], $_temp)) {
        $GLOBALS['display_remote_calendars'][] = $id['url'];
    }
}
$GLOBALS['prefs']->setValue('display_remote_cals', serialize($GLOBALS['display_remote_calendars']));

if (count($GLOBALS['display_calendars']) == 0) {
    $cals = Kronolith::listCalendars(true);
    if (!count($cals) && Auth::getAuth()) {
        /* Create a personal calendar */
        $GLOBALS['display_calendars'] = array(Auth::getAuth());

        /* If this share doesn't exist then create it. */
        if (!$GLOBALS['shares']->exists(Auth::getAuth())) {
            require_once HORDE_BASE . '/lib/Identity.php';
            $identity = &new Identity();
            $name = $identity->getValue('fullname');
            if (trim($name) == '') {
                $name = Auth::removeHook(Auth::getAuth());
            }
            $share = &$GLOBALS['shares']->newShare(Auth::getAuth());
            $share->setOwner(Auth::getAuth(), false);
            $share->setShareName(sprintf(_("%s's Calendar"), $name), false);
            $GLOBALS['shares']->addShare($share);
        }
        $GLOBALS['prefs']->setValue('display_cals', serialize($GLOBALS['display_calendars']));
    }
}

// Create a calendar backend object.
$GLOBALS['calendar'] = &Kronolith_Driver::factory($conf['calendar']['driver'],
                                                  Horde::getDriverConfig('calendar'));
