<?php
/**
 * $Horde: kronolith/deleventaction.php,v 1.10 2003/05/22 18:20:18 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$calendar = &Kronolith_Driver::factory($conf['calendar']['driver'], $conf['calendar']['params']);
$calendar->open(Horde::getFormData('calendar'));
if ($eventID = Horde::getFormData('eventID')) {
    $event = &$calendar->getEventObject($eventID);
    if (!$event) {
        if (($url = Horde::getFormData('url')) === null) {
            $url = Horde::applicationUrl($prefs->getValue('defaultview') . '.php', true);
        }
        header('Location: ' . $url);
        exit;
    }
    $share = &$shares->getShare($event->getCalendar());
    if (!$share->hasPermission(Auth::getAuth(), _PERMS_DELETE, $event->getCreatorID())) {
        $notification->push(_("You do not have permission to delete this event."), 'horde.warning');
    } else {
        if ($event->hasRecurType(KRONOLITH_RECUR_NONE) || Horde::getFormData('all')) {
            $calendar->deleteEvent($event->getID());
        } elseif (Horde::getFormData('future')) {
            $event->setRecurEndTimestamp(mktime(1, 1, 1,
                                                Horde::getFormData('month', date('n')),
                                                Horde::getFormData('mday', date('j')) - 1,
                                                Horde::getFormData('year', date('Y'))));
            $event->save();
        } elseif (Horde::getFormData('current')) {
            $event->addException(Horde::getFormData('year'),
                                 Horde::getFormData('month'),
                                 Horde::getFormData('mday'));
            $event->save();
        }
    }
}

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $day = date('j', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $day = Horde::getFormData('mday', date('j'));
    $year = Horde::getFormData('year', date('Y'));
}

if ($url = Horde::getFormData('url')) {
    $location = $url;
} else {
    $url = Horde::addParameter($prefs->getValue('defaultview') . '.php', 'month', $month);
    $url = Horde::addParameter($url, 'year', $year);
    $url = Horde::addParameter($url, 'mday', $day);
    $location = Horde::applicationUrl($url, true);
}

$location = Horde::addParameter($location, 'unique=' . md5(microtime()));
header('Location: ' . $location);
