<?php
/**
 * Kronolith Configuration File
 *
 * This file contains global configuration settings for Kronolith. Values
 * may be safely edited by hand. Use conf.php.dist as a reference.
 *
 * Strings should be enclosed in 'quotes'.
 * Integers should be given literally (without quotes).
 * Boolean values may be true or false (no quotes).
 *
 * $Horde: kronolith/config/conf.php.dist,v 1.29.2.3 2003/04/04 19:23:54 chuck Exp $
 */


/**
 ** Calendar Driver Settings
 **/

// What calendar backend is being used? Right now, the only options are
// 'mcal' and 'sql', but others may appear at some point in the future.
$conf['calendar']['driver'] = 'kolab';

// What MCAL driver is being used? 'mstore' is the local file driver,
// and is the only one with extensive testing. There is also an ICAP
// driver, and theoretically an ICAP server, but Kronolith has not
// been tested with them.
$conf['calendar']['params']['folder'] = 'INBOX/Calendar';
$conf['calendar']['params']['server'] = 'localhost';
// $conf['calendar']['params']['driver'] = 'mstore';

// The mstore driver requires a username and a password that is in
// /etc/mpasswd in order to access local calendars.
// $conf['calendar']['params']['username'] = '';
// $conf['calendar']['params']['password'] = '';

// This is an example configuration for an sql driver, in this case MySQL.
// $conf['calendar']['params']['phptype'] = 'mysql';
// $conf['calendar']['params']['hostspec'] = 'localhost';
// $conf['calendar']['params']['username'] = 'horde';
// $conf['calendar']['params']['password'] = '*****';
// $conf['calendar']['params']['database'] = 'horde';
// $conf['calendar']['params']['table'] = 'kronolith_events';


/**
 ** Metadata Settings
 **/

// If this is true, then an array of keywords will be read from
// config/keywords.php and you will be able to assign any or all of
// them to events.
$conf['metadata']['keywords'] = false;


/**
 ** Menu settings
 **/

// Should we display a Import/Export link in the Horde application
// menus?
$conf['menu']['import_export'] = true; 

// This is an array of applications (using the names defined in
// horde/config/registry.php) to include links to in the menubar. An
// example providing a link to Turba (an addressbook program) would
// be: $conf['menu']['apps'] = array('turba');
$conf['menu']['apps'] = array();
