<?php
/**
 * $Horde: kronolith/addevent.php,v 1.42 2003/05/22 21:48:27 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require KRONOLITH_BASE . '/lib/base.php';

$event = &$calendar->getEventObject();

$calendar_id = $prefs->getValue('default_share');

if (!$timestamp = Horde::getFormData('timestamp')) {
    $month = Horde::getFormData('month', date('n'));
    $day = Horde::getFormData('mday', date('j'));
    $year = Horde::getFormData('year', date('Y'));
    $hour = date('H');
    $min = date('i');
    $timestamp = mktime($hour, $min - ($min % 5), 0, $month, $day, $year);
}

$url = Horde::getFormData('url');

$event->setStartTimestamp($timestamp);
// Default to a 1 hour duration.
$event->setEndTimestamp($timestamp + 3600);
$event->setRecurType(KRONOLITH_RECUR_NONE);
$month = date('n', $timestamp);
$year = date('Y', $timestamp);

$title = _("Add a new event");
$js_onLoad = null;

$buttons = array('<input type="submit" class="button" name="save" value="' . _("Save Event") . '" onclick="return checkCategory();" />');
if (isset($url)) {
    $cancelurl = $url;
} else {
    $cancelurl = Horde::addParameter('month.php', 'month=' . $month);
    $cancelurl = Horde::addParameter($cancelurl, 'year=' . $year);
    $cancelurl = Horde::applicationUrl($cancelurl);
}

require KRONOLITH_TEMPLATES . '/common-header.inc';
Kronolith::menu();
require KRONOLITH_TEMPLATES . '/edit/javascript.inc';
require KRONOLITH_TEMPLATES . '/edit/edit.inc';
require KRONOLITH_TEMPLATES . '/common-footer.inc';
