<?php
/**
 * $Horde: imp/prefs.php,v 2.196 2003/06/12 06:10:57 slusarz Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function handle_folderselect($updated)
{
    global $conf, $prefs, $imp;

    if ($conf['user']['allow_folders']) {
        $drafts_folder = Horde::getFormData('drafts');
        $drafts_new = String::convertCharset(Horde::getFormData('drafts_new'), NLS::getCharset(), 'UTF7-IMAP');
        if (isset($drafts_folder) && !$prefs->isLocked('drafts_folder')) {
            if (empty($drafts_folder) && !empty($drafts_new)) {
                $drafts_folder = $drafts_new;
                include_once IMP_BASE . '/lib/Folder.php';
                $imp_folder = &IMP_Folder::singleton();
                $imp_folder->create($imp['stream'], IMP::addPreambleString($drafts_folder), $prefs->getValue('subscribe'));
                unset($imp['imaptree']);
            } else {
                $drafts_folder = IMP::stripPreambleString($drafts_folder);
            }
            if (!empty($drafts_folder)) {
                $prefs->setValue('drafts_folder', $drafts_folder);
                $updated = true;
            }
        }
    }
    return $updated;
}

function handle_trashselect($updated)
{
    global $conf, $prefs, $imp;

    if ($conf['user']['allow_folders']) {
        $trash_folder = Horde::getFormData('trash');
        $trash_new = String::convertCharset(Horde::getFormData('trash_new'), NLS::getCharset(), 'UTF7-IMAP');
        if (isset($trash_folder) && !$prefs->isLocked('trash_folder')) {
            if (empty($trash_folder) && !empty($trash_new)) {
                $trash_folder = $trash_new;
                include_once IMP_BASE . '/lib/Folder.php';
                $imp_folder = &IMP_Folder::singleton();
                $imp_folder->create($imp['stream'], IMP::addPreambleString($trash_folder), $prefs->getValue('subscribe'));
                unset($imp['imaptree']);
            } else {
                $trash_folder = IMP::stripPreambleString($trash_folder);
            }
            if (!empty($trash_folder)) {
                $prefs->setValue('trash_folder', $trash_folder);
                $updated = true;
            }
        }
    }
    return $updated;
}

function handle_sourceselect($updated)
{
    global $prefs;

    $search_sources = Horde::getFormData('search_sources');
    if (!is_null($search_sources)) {
        $prefs->setValue('search_sources', $search_sources);
        $updated = true;
    }

    $search_fields_string = Horde::getFormData('search_fields_string');
    if (!is_null($search_fields_string)) {
        $prefs->setValue('search_fields', $search_fields_string);
        $updated = true;
    }

    $add_source = Horde::getFormData('add_source');
    if (!is_null($add_source)) {
        $prefs->setValue('add_source', $add_source);
        $updated = true;
    }
    return $updated;
}

function handle_identityselect($updated)
{
    global $prefs;

    $default_identity = Horde::getFormData('default_identity');
    if (!is_null($default_identity)) {
        $identities = @unserialize($prefs->getValue('identities'));
        if ($identities && count($identities) > 0 && isset($identities[$default_identity])) {
            if (!isset($prefs->prefs['default_identity'])) {
                $acl = 0;
                if ($prefs->isLocked('identities')) {
                    $acl |= _PREF_LOCKED;
                }
                if ($prefs->isShared('identities')) {
                    $acl |= _PREF_SHARED;
                }
                $prefs->add('default_identity', '', $acl);
            }
            $prefs->setValue('default_identity', $default_identity);
            if (!$prefs->isLocked('fullname')) {
                $prefs->setValue('fullname', $identities[$default_identity]['fullname']);
            }
            if (!$prefs->isLocked('from_addr')) {
                $prefs->setValue('from_addr', $identities[$default_identity]['from_addr']);
            }
            if (!$prefs->isLocked('replyto_addr')) {
                $prefs->setValue('replyto_addr', $identities[$default_identity]['replyto_addr']);
            }
            if (!$prefs->isLocked('signature')) {
                $prefs->setValue('signature', $identities[$default_identity]['signature']);
            }
            if (!$prefs->isLocked('sig_dashes')) {
                $prefs->setValue('sig_dashes', $identities[$default_identity]['sig_dashes']);
            }
            if (!$prefs->isLocked('sig_first')) {
                $prefs->setValue('sig_first', $identities[$default_identity]['sig_first']);
            }
            $updated = true;
        }
    }
    return $updated;
}

function handle_initialpageselect($updated)
{
    global $prefs;

    $initial_page = Horde::getFormData('initial_page');
    if ($initial_page != 'folders.php' &&
        substr($initial_page, 0, strlen(IMP::preambleString())) == IMP::preambleString()) {
        $initial_page = substr($initial_page, strlen(IMP::preambleString()));
    }
    $prefs->setValue('initial_page', $initial_page);
    return true;
}

/**
 * Process the 'default_encrypt' preference.
 * See: templates/prefs/encryptselect.inc
 */
function handle_encryptselect($updated)
{
    global $prefs;

    $default_encrypt = Horde::getFormData('default_encrypt');
    $prefs->setValue('default_encrypt', $default_encrypt);
    return true;
}


function prefs_callback()
{
    global $prefs, $js_onLoad, $imp;

    if ($prefs->isDirty('subscribe')) {
        if (isset($imp['imaptree'])) {
            unset($imp['imaptree']);
        }
    }

    if ($prefs->isDirty('theme') || $prefs->isDirty('language')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

define('IMP_BASE', dirname(__FILE__));
$authentication = OP_HALFOPEN;
require_once IMP_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require IMP_BASE . '/config/servers.php';
require IMP_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');
$js_onLoad = null;

if (PrefsUI::handleForm($group)) {
    $group = null;
    require IMP_BASE . '/config/prefs.php';
}

$title = _("User Options");
require IMP_TEMPLATES . '/common-header.inc';
IMP::menu();
IMP::status();

/* Assign variables for select lists. */
if (!$prefs->isLocked('timezone')) {
    $timezone_options = &$tz;
}
require_once IMP_BASE . '/lib/Maintenance/imp.php';
$maint = &new Maintenance_IMP();
foreach (($maint->exportIntervalPrefs()) as $val) {
    $$val = &$intervals;
}

/* Show the UI. */
PrefsUI::generateUI($group);

require IMP_TEMPLATES . '/common-footer.inc';

// Catch error messages from c-client.
imap_errors();
