<?php
/**
 * $Horde: imp/pgp.php,v 2.59 2003/06/17 07:53:46 slusarz Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function _printKeyInfo($key = '')
{
    global $imp_pgp;

    $key_info = $imp_pgp->pgpPrettyKey($key);

    if (empty($key_info)) {
        _textWindowOutput('PGP Key Information', _("Invalid key"));
    } else {
        _textWindowOutput('PGP Key Information', $key_info);
    }

    return;
}

function _outputPassphraseDialog()
{
    global $notification, $prefs, $registry, $secure_check, $selfURL;

    if (is_a($secure_check, 'PEAR_Error')) {
        $notification->push($secure_check, 'horde.warning');
    }

    $title = _("PGP Passphrase Input");
    $js_onLoad = 'document.passphrase_dialog.passphrase.focus();';
    require IMP_TEMPLATES . '/common-header.inc';
    $submit_url = Horde::addParameter($selfURL, 'actionID', 'process_passphrase_dialog');
    IMP::status();
    require IMP_TEMPLATES . '/pgp/passphrase.inc';
}

function _importKeyDialog($target)
{
    global $actionID, $notification, $prefs, $registry, $selfURL;

    $title = _("Import PGP Key");
    require IMP_TEMPLATES . '/common-header.inc';
    IMP::status();
    require IMP_TEMPLATES . '/pgp/import_key.inc';
}

function _actionWindow()
{
    $oid = Horde::getFormData('passphrase_action');
    require_once HORDE_BASE . '/lib/SessionObjects.php';
    $cacheSess = &Horde_SessionObjects::singleton();
    $cacheSess->setPruneFlag($oid, true);
    Horde::closeWindowJS($cacheSess->query($oid));
}

function _reloadWindow()
{
    Horde::closeWindowJS('opener.focus();opener.location.href="' . Horde::getFormData('reload') . '";');
}

function _getImportKey()
{
    global $notification;

    $key = Horde::getFormData('import_key');
    if (!empty($key)) {
        return $key;
    }

    require_once HORDE_BASE . '/lib/Server.php';
    $res = Server::wasFileUploaded('upload_key', _("key"));
    if (!is_a($res, 'PEAR_Error')) {
        foreach (file($_FILES['upload_key']['tmp_name']) as $value) {
            $temp_array[] = rtrim($value);
        }
        return implode("\n", $temp_array);
    } else {
        $notification->push($res, 'horde.error');
        return;
    }
}

function _textWindowOutput($filename, $msg)
{
    global $browser;

    $browser->downloadHeaders($filename, 'text/plain; charset=' . NLS::getCharset(), true, strlen($msg));
    echo $msg;
}


define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/PGP.php';

$imp_pgp = &new IMP_PGP();
$secure_check = $imp_pgp->requireSecureConnection();
$selfURL = Horde::applicationUrl('pgp.php');

/* Run through the action handlers */
$actionID = Horde::getFormData('actionID');
switch ($actionID) {
case 'generate_key':
    /* Check that fields are filled out (except for Comment) and that the
       passphrases match. */
    $realname = Horde::getFormData('generate_realname');
    $email = Horde::getFormData('generate_email');
    $comment = Horde::getFormData('generate_comment');
    $keylength = Horde::getFormData('generate_keylength');
    $passphrase1 = Horde::getFormData('generate_passphrase1');
    $passphrase2 = Horde::getFormData('generate_passphrase2');

    if (empty($realname) || empty($email)) {
        $notification->push(_("Name and/or email can not be empty"), 'horde.error');
    } elseif (empty($passphrase1) || empty($passphrase2)) {
        $notification->push(_("Passphrases can not be empty"), 'horde.error');
    } elseif ($passphrase1 !== $passphrase2) {
        $notification->push(_("Passphrases do not match"), 'horde.error');
    } else {
        $result = $imp_pgp->generatePersonalKeys($realname, $email, $passphrase1, $comment, $keylength);
        if (is_a($result, 'PEAR_Error')) {
            $notification->push($result, $result->getCode());
        } else {
            $notification->push(_("Personal PGP keypair generated successfully."), 'horde.success');
        }
    }
    break;

case 'delete_key':
    $imp_pgp->deletePersonalKeys();
    $notification->push(_("Personal PGP keys deleted successfully."), 'horde.success');
    break;

case 'import_public_key':
    _importKeyDialog('process_import_public_key');
    exit;

case 'process_import_public_key':
    $publicKey = _getImportKey();
    if (empty($publicKey)) {
        $notification->push(_("No PGP public key imported."), 'horde.error');
        $actionID = 'import_public_key';
        _importKeyDialog('process_import_public_key');
    } else {
        /* Add the public key to the storage system. */
        $key_info = $imp_pgp->addPublicKey($publicKey);
        if (is_a($key_info, 'PEAR_Error')) {
            $notification->push($key_info, 'horde.error');
            $actionID = 'import_public_key';
            _importKeyDialog('process_import_public_key');
        } else {
            foreach ($key_info['signature'] as $sig) {
                $notification->push(sprintf(_("PGP Public Key for \"%s (%s)\" was successfully added."), $sig['name'], $sig['email']), 'horde.success');
            }
            _reloadWindow();
        }
    }
    exit;

case 'import_personal_public_key':
    _importKeyDialog('import_personal_private_key');
    exit;

case 'import_personal_private_key':
    /* Check the public key. */
    if (!($publicKey = _getImportKey())) {
        $notification->push(_("No personal PGP public key imported."), 'horde.error');
        $actionID = 'import_personal_public_key';
        _importKeyDialog('import_personal_private_key');
    } else {
        if (!($key_info = $imp_pgp->pgpPacketInformation($publicKey))) {
            $notification->push(_("Invalid personal PGP public key."), 'horde.error');
            $actionID = 'import_personal_public_key';
            _importKeyDialog('import_personal_private_key');
        } else {
            $imp_pgp->addPersonalPublicKey($publicKey);
            $notification->push(_("PGP public key successfully added."), 'horde.success');
            _importKeyDialog('process_import_personal_key');
        }
    }
    exit;

case 'process_import_personal_key':
    /* Check the private key. */
    if (!($privateKey = _getImportKey())) {
        $notification->push(_("No personal PGP private key imported."), 'horde.error');
        $actionID = 'import_personal_private_key';
        _importKeyDialog('process_import_personal_key');
    } else {
        if (!($key_info = $imp_pgp->pgpPacketInformation($privateKey))) {
            $notification->push(_("Invalid personal PGP private key."), 'horde.error');
            $actionID = 'import_personal_private_key';
            _importKeyDialog('process_import_personal_key');
        } else {
            $imp_pgp->addPersonalPrivateKey($privateKey);
            $notification->push(_("PGP private key successfully added."), 'horde.success');
            _reloadWindow();
        }
    }
    exit;

case 'view_public_key':
    $key = $imp_pgp->getPublicKey(Horde::getFormData('email'));
    if (is_a($key, 'PEAR_Error')) {
        $key = $key->getMessage();
    }
    _textWindowOutput('PGP Public Key', $key);
    exit;

case 'view_personal_public_key':
    _textWindowOutput('PGP Personal Public Key', $imp_pgp->getPersonalPublicKey());
    exit;

case 'info_public_key':
    $key = $imp_pgp->getPublicKey(Horde::getFormData('email'));
    if (is_a($key, 'PEAR_Error')) {
        $key = $key->getMessage();
    }
    _printKeyInfo($key);
    exit;

case 'info_personal_public_key':
    _printKeyInfo($imp_pgp->getPersonalPublicKey());
    exit;

case 'view_personal_private_key':
    _textWindowOutput('PGP Personal Private Key', $imp_pgp->getPersonalPrivateKey());
    exit;

case 'info_personal_private_key':
    _printKeyInfo($imp_pgp->getPersonalPrivateKey());
    exit;

case 'delete_public_key':
    $result = $imp_pgp->deletePublicKey(Horde::getFormData('email'));
    if (is_a($result, 'PEAR_Error')) {
        $notification->push($result, $result->getCode());
    } else {
        $notification->push(sprintf(_("PGP Public Key for \"%s\" was successfully deleted."), Horde::getFormData('email')), 'horde.success');
    }
    break;

case 'pgp_enable':
    $prefs->setValue('use_pgp', Horde::getFormData('use_pgp'));
    break;

case 'save_options':
    $prefs->setValue('use_pgp', Horde::getFormData('use_pgp'));
    $prefs->setValue('pgp_attach_pubkey', Horde::getFormData('pgp_attach_pubkey'));
    $prefs->setValue('pgp_scan_body', Horde::getFormData('pgp_scan_body'));
    $notification->push(_("Preferences successfully updated."), 'horde.success');
    break;

case 'save_attachment_public_key':
    require_once HORDE_BASE . '/lib/SessionObjects.php';
    require_once HORDE_BASE . '/lib/MIME/Part.php';

    /* Retrieve the key from the cache. */
    $cache = &Horde_SessionObjects::singleton();
    $mime_part = $cache->query(Horde::getFormData('mimecache'));
    $mime_part->transferDecodeContents();

    /* Add the public key to the storage system. */
    $key_info = $imp_pgp->addPublicKey($mime_part->getContents());
    if (is_a($key_info, 'PEAR_Error')) {
        $notification->push($key_info, $key_info->getCode());
    } else {
        Horde::closeWindowJS();
    }
    exit;

case 'open_passphrase_dialog':
    if ($imp_pgp->getPassphrase()) {
        Horde::closeWindowJS();
    } else {
        _outputPassphraseDialog();
    }
    exit;

case 'process_passphrase_dialog':
    if (is_a($secure_check, 'PEAR_Error')) {
        _outputPassphraseDialog();
    } elseif (Horde::getFormData('passphrase')) {
        if ($imp_pgp->storePassphrase(Horde::getFormData('passphrase'))) {
            if (Horde::getFormData('passphrase_action')) {
                _actionWindow();
            } elseif (Horde::getFormData('reload')) {
                _reloadWindow();
            } else {
                Horde::closeWindowJS();
            }
        } else {
            $notification->push("Invalid passphrase entered.", 'horde.error');
            _outputPassphraseDialog();
        }
    } else {
        $notification->push("No passphrase entered.", 'horde.error');
        _outputPassphraseDialog();
    }
    exit;

case 'unset_passphrase':
    $imp_pgp->unsetPassphrase();
    $notification->push(_("Passphrase successfully unloaded."), 'horde.success');
    break;

case 'send_public_key':
    $result = $imp_pgp->sendToPublicKeyserver($imp_pgp->getPersonalPublicKey());
    if (is_a($result, 'PEAR_Error')) {
        $notification->push($result, $result->getCode());
    } else {
        $notification->push(_("Key successfully sent to the public keyserver."), 'horde.success');
    }
    break;
}

/* Get list of Public Keys on keyring. */
$pubkey_list = $imp_pgp->listPublicKeys();
if (is_a($pubkey_list, 'PEAR_Error')) {
    $notification->push($pubkey_list, $pubkey_list->getCode());
}

/* Get passphrase (if available). */
$passphrase = $imp_pgp->getPassphrase();

$title = sprintf(_("%s PGP Administration"), _("Mail"));
$js_onLoad = null;
require IMP_TEMPLATES . '/common-header.inc';
IMP::menu();
IMP::status();
require_once HORDE_BASE . '/lib/PrefsUI.php';
require IMP_BASE . '/config/prefs.php';

/* If PGP preference not active, do NOT show PGP Admin screen. */
if ($prefs->getValue('use_pgp')) {
    $openpgpwin = $imp_pgp->getJSOpenWinCode('open_passphrase_dialog');
    require_once IMP_TEMPLATES . '/pgp/open_pgp_win.js';
    require_once IMP_TEMPLATES . '/pgp/open_pgp_import.js';
    require IMP_TEMPLATES . '/pgp/pgp.inc';
} else {
    require IMP_TEMPLATES . '/pgp/notactive.inc';
}

require IMP_TEMPLATES . '/common-footer.inc';
