
#include "baserules.h"
#include "ksopts.h"

#include <stdio.h>

void KSMBaseRules::sirc_receive(QCString, bool)
{
}

void KSMBaseRules::control_message(int, QString)
{
}

filterRuleList *KSMBaseRules::defaultRules()
{
  filterRule *fr;
  filterRuleList *frl = new filterRuleList();
  frl->setAutoDelete(TRUE);
  if( ksopts->ksircColors ){
    // 3 stage rule to filter:
    // ~blah~<something> stuff with ~ here and ~ there
    // Here's the path follows
    // =>~blah~;;;<something> with ~ here and ~ there
    // =>~blah~;;;<something> with ~~ here and ~~ there
    // =>~blah~<something> with ~~ here and ~ there
    // Basic problem was getting it not to change ~blah~ into ~~blah~~
    fr = new filterRule();
    fr->desc = "Add marker to second ~";
    fr->search = "^~\\S+~";
    fr->from = "^~(\\S+)~";
    fr->to = "~;;;$1~;;;";
    frl->append(fr);
    fr = new filterRule();
    fr->desc = "Escape kSirc Control Codes";
    fr->search = "~";
    fr->from = "(?g)~(?!;;;)";
    fr->to = "$1~~";
    frl->append(fr);
    fr = new filterRule();
    fr->desc = "Remove marker to second";
    fr->search = "^~;;;\\S+~;;;";
    fr->from = "^~;;;(\\S+)~;;;";
    fr->to = "~$1~";
    frl->append(fr);

  }
  else{
    // If we don't escape all ~'s at least esacpe the ones in
    // email/part joins etc.
    fr = new filterRule();
    fr->desc = "Search for dump ~'s";
    fr->search = "\\W~\\S+@\\S+\\W";
    fr->from = "~(\\S+@)";
    fr->to = "~~$1";
    frl->append(fr);
  }
  if(ksopts->mircColors){
    fr = new filterRule();
    fr->desc = "Remove mirc Colours";
    fr->search = "\\x03";
    fr->from = "(?g)\\x03(?:\\d{0,2},{0,1}\\d{0,2})";
    fr->to = "";
    frl->append(fr);
  }
  if( ksopts->nickForeground.isValid() ){
    fr = new filterRule();
    fr->desc = "Highlight nicks in colours";
    fr->search = "^(?:~\\S+~)<\\S+>";
    fr->from = "^((?:~\\S+~))<(\\S+)>";
/*    if( ksopts->nickBackground >= 0)
      sprintf(to, "<~%d,%d$1~c>", ksopts->nickForeground,
	                          ksopts->nickBackground);
    else*/
      sprintf(to, "$1<~n$2~c>");//, ksopts->nickForeground);
    fr->to = to;
    frl->append(fr);
  }
  if( ksopts->ownNickColor.isValid() ){
    QString nick = ksopts->nick;
    if ( !nick.isEmpty() ) {
	if(nick.length() > 83){
	    qDebug("Nick too long");
	    nick.truncate( 83 );
	}
	sprintf(match_us,
		"(?i)<\\S+>.*\\s%s(,.*|\02:.*|:.*|\\s.*|$)", nick.latin1());
	sprintf(to_us,
		"$1~o");//, ksopts->ownNickColor);
	fr = new filterRule();
	fr->desc = "Highlight our nick";
	fr->search = match_us;
	fr->from = "(<\\S+>)";
	fr->to = to_us;
	frl->append(fr);
    }
  }

  // Default rules alays in place
  fr = new filterRule();
  fr->desc = "Remove Just bold in parts and joins";
  fr->search = "\\*\\x02\\S+\\x02\\*";
  fr->from = "\\*\\x02(\\S+)\\x02\\*";
  fr->to = "\\*$1\\*";
  frl->append(fr);

  return frl;
}
