/**
 * kmacctcachedimap.h
 *
 * Copyright (c) 2000-2002 Michael Haeckel <haeckel@kde.org>
 *
 * This file is based on kmacctexppop.h by Don Sanders
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef KMAcctCachedImap_h
#define KMAcctCachedImap_h

#include "imapaccountbase.h"

#include <qguardedptr.h>

class KMFolderCachedImap;
class KMFolderTreeItem;
class KMImapJob;
namespace KMail {
  class IMAPProgressDialog;
  class CachedImapJob;
};

using KMail::CachedImapJob;

namespace KIO {
  class Job;
};


class KMAcctCachedImap: public KMail::ImapAccountBase
{
  Q_OBJECT
  friend class KMImapJob;
  friend class CachedImapJob;

protected: // ### Hacks
  void setPrefixHook();

public:
  typedef KMail::ImapAccountBase base;

  virtual ~KMAcctCachedImap();
  virtual void init();

  /** A weak assignment operator */
  virtual void pseudoAssign( const KMAccount * a );

  /**
   * Overloaded to make sure it's never set for cached IMAP.
   */
  virtual void setAutoExpunge(bool);

  /**
   * Inherited methods.
   */
  virtual QString type() const;
  virtual void processNewMail( bool i ) { processNewMail( mFolder, i ); }

  void processNewMail( KMFolderCachedImap*, bool );

  struct jobData // should be JobData
  {
    // Needed by QMap
    jobData() : url(QString::null), parent(0), total(1), done(0), offset(0), inboxOnly(false), quiet(false) {}
    jobData( QString _url, KMFolderCachedImap *_parent,
	     int _total = 1, int _done = 0, bool _quiet = false, bool _inboxOnly = false )
      : url(_url), parent(_parent), total(_total), done(_done), offset(0),
	inboxOnly(_inboxOnly), quiet(_quiet)
      {}
    // Return "url" in a form that can be displayed in HTML (w/o password)
    QString htmlURL() const;

    QString path;
    QString url;
    QByteArray data;
    QCString cdata;
    QStringList items;
    KMFolderCachedImap *parent;
    int total, done, offset;
    bool inboxOnly, quiet;
  };
  typedef QMap<KIO::Job *, jobData>::Iterator JobIterator;
  /**
   * Call this when starting a new job
   */
  void insertJob( KIO::Job* job, const jobData& data ) {
    mapJobData.insert( job, data );
    displayProgress();
  }
  /**
   * Look for the jobData related to a given job. Compare with end()
   */
  JobIterator findJob( KIO::Job* job ) { return mapJobData.find( job ); }
  JobIterator jobsEnd() { return mapJobData.end(); }
  /**
   * Call this when a job is finished.
   * Don't use @p *it afterwards!
   */
  void removeJob( JobIterator& it ) {
    mapJobData.remove( it );
    displayProgress();
  }

  /**
   * Update the progress bar
   */
  void displayProgress();

  /**
   * Kill all jobs related the the specified folder
   */
  void killJobsForItem(KMFolderTreeItem * fti);

  /**
   * Kill the slave if any jobs are active
   */
  void killAllJobs( bool disconnectSlave=false );

  /**
   * Set the account idle or busy
   */
  void setIdle(bool aIdle) { mIdle = aIdle; }

  void slaveDied() { mSlave = 0; killAllJobs(); }

  /**
   * Set the top level pseudo folder
   */
  virtual void setImapFolder(KMFolderCachedImap *);

  KMail::IMAPProgressDialog * imapProgressDialog() const;
  bool isProgressDialogEnabled() const { return mProgressDialogEnabled; }
  void setProgressDialogEnabled( bool enable ) { mProgressDialogEnabled = enable; }

  virtual void readConfig( /*const*/ KConfig/*Base*/ & config );
  virtual void writeConfig( KConfig/*Base*/ & config ) /*const*/;

  /**
   * Invalidate the local cache.
   */
  virtual void invalidateIMAPFolders();
  virtual void invalidateIMAPFolders( KMFolderCachedImap* );

  /**
   * Connect to the server, if no connection is active.
   * If the connection can't be made, it sets the mSyncActive to false
   */
  virtual ConnectionState makeConnection();

public slots:
  void processNewMail() { processNewMail( mFolder, true ); }

  /**
   * Display an error message
   */
  void slotSlaveError(KIO::Slave *aSlave, int, const QString &errorMsg);

protected:
  friend class KMAcctMgr;
  KMAcctCachedImap(KMAcctMgr* owner, const QString& accountName);

protected slots:
  /**
   * Send a NOOP command or log out when idle
   */
  void slotIdleTimeout();

  /**
   * Kills all jobs
   */
  void slotAbortRequested();

  /**
   * Only delete information about the job
   */
  void slotSimpleResult(KIO::Job * job);

  /** new-mail-notification for the current folder (is called via folderComplete) */
  void postProcessNewMail(KMFolderCachedImap*, bool);
  void postProcessNewMail( KMFolder * f ) { base::postProcessNewMail( f ); }

private:
  QMap<KIO::Job *, jobData> mapJobData;
  QPtrList<CachedImapJob> mJobList;
  KMFolderCachedImap *mFolder;
  mutable QGuardedPtr<KMail::IMAPProgressDialog> mProgressDlg;
  bool mProgressDialogEnabled;
  bool mSyncActive;
};

#endif /*KMAcctCachedImap_h*/
