#include <dcopclient.h>
#include <qfile.h>
#include <qtextstream.h>
#include <kurlrequester.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

class KTestSendVCalWindow : public KURLRequester
{
    Q_OBJECT

public:
    KTestSendVCalWindow();
    ~KTestSendVCalWindow();
    
public slots:
    void slotShoot( const QString& fileName ) {
        /*
        QFile file( fileName );
        if( file.open( IO_ReadOnly ) ) {
            QTextStream ts( &file );
            QString fileContents = ts.read();
            QByteArray data;
            QDataStream arg( data, IO_WriteOnly );
            arg << fileContents;
        */
            if( !kapp->dcopClient()->send( "korganizer*", "KOrganizerIface",
                                  "meetingRequest(QString)", fileName ) ) { //data ) ) {
                qDebug( "DCOP Communication Error, unable to communicate with KOrganizer" );
                return;
            }
        /*
            file.close();
        } else
            qDebug( "Could not open file %s", fileName.local8Bit().data() );
        */
    }
};


KTestSendVCalWindow::KTestSendVCalWindow() : KURLRequester( 0 ) 
{
    connect( this, SIGNAL( returnPressed( const QString& ) ),
             this, SLOT( slotShoot( const QString& ) ) );
}

KTestSendVCalWindow::~KTestSendVCalWindow()
{
}


int main( int argc, char* argv[] )
{
    KAboutData aboutData( "blah", "BLAH",
                          "0.1", "blahblahblah",
                          KAboutData::License_Artistic,
                          "(c) 2002, Matthias Kalle Dalheimer");
    KCmdLineArgs::init( argc, argv, &aboutData );
    KApplication app;
    
    KTestSendVCalWindow w;
    w.show();
    
    QObject::connect( &app, SIGNAL( lastWindowClosed() ), &app, SLOT( quit() ) );
    return app.exec();
}

#include "testsendvcal.moc"

                            
