#ifndef KSIRCPROCESS
#define KSIRCPROCESS

class KSircProcess;
class KSircTopLevel;

#include <qdict.h>
#include <qobject.h>

class KProcess;
class KSircIOController;
class KSircMessageReceiver;

class KSircProcess : public QObject
{
  Q_OBJECT
  friend class KSircIOController;
public:
  KSircProcess(const QString &socket, char *_server=0L, QObject * parent=0, const char * name=0);
  virtual ~KSircProcess();

  QDict<KSircMessageReceiver> &getWindowList()
    {
      return TopList;
    }

  QPtrList<KSircMessageReceiver> messageReceivers() const;

    QString serverName() const { return server; }

signals:
  void ProcMessage(QString, int, QString);

public slots:
 virtual void ServMessage(QString server, int command, QString args);
 virtual void new_toplevel(QString);
 //  virtual void new_ksircprocess(QString);
 virtual void close_toplevel(KSircTopLevel *, QString);
 virtual void default_window(KSircTopLevel *);
 virtual void recvChangeChannel(const QString &, const QString &);

 virtual void filters_update();

  virtual void notify_forw_online(QString);
  virtual void notify_forw_offline(QString);

protected slots:
  virtual void clean_toplevel(KSircTopLevel *clean);
  virtual void request_quit( const QCString& command );
  virtual void do_quit();

  virtual void turn_on_autocreate();


private:
  void base_filters();
  void cleanup();

  KSircIOController *iocontrol;
  KProcess *proc;

  QDict<KSircMessageReceiver> TopList;

  bool running_window;
  bool default_follow_focus;
  bool auto_create_really;

  char *server;
};

#endif
