/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGIMPORTPLUGINKMY_H
#define SKGIMPORTPLUGINKMY_H
/** @file
* This file is Skrooge plugin for KMY import / export.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "skgimportplugin.h"

#include <QSet>
class SKGDocumentBank;
class SKGUnitObject;
class SKGAccountObject;
class SKGCategoryObject;
class SKGOperationObject;
class SKGPayeeObject;
class QDomDocument;
class QDomElement;

/**
 * This file is Skrooge plugin for KMY import / export.
 */
class SKGImportPluginKmy : public SKGImportPlugin
{
    Q_OBJECT
    Q_INTERFACES(SKGImportPlugin)

public:
    /**
     * Default constructor
     * @param iImporter the parent importer
     */
    explicit SKGImportPluginKmy(QObject* iImporter, const QVariantList& iArg);

    /**
     * Default Destructor
     */
    virtual ~SKGImportPluginKmy();

    /**
     * To know if import is possible with this plugin
     */
    virtual inline bool isImportPossible();

    /**
     * Import a file
     * @return an object managing the error.
     *   @see SKGError
     */
    virtual SKGError importFile();

    /**
     * To know if export is possible with this plugin
     * @return true or false
     */
    virtual bool isExportPossible();


    /**
     * Export a file
     * @return an object managing the error.
     *   @see SKGError
     */
    virtual SKGError exportFile();

    /**
     * Return the mime type filter
     * @return the mime type filter. Example: "*.csv|CSV file"
     */
    virtual QString getMimeTypeFilter() const;


private:
    Q_DISABLE_COPY(SKGImportPluginKmy)

    static SKGError exportOperation(const SKGOperationObject& iOperation, QDomDocument& iDoc, QDomElement& iTransaction);
    static QString kmyValue(double iValue);

    static QSet<QString>  m_opTreated;
    static QMap<QString, SKGUnitObject> m_mapIdUnit;
    static QMap<QString, SKGAccountObject> m_mapIdAccount;
    static QMap<QString, SKGCategoryObject> m_mapIdCategory;
    static QMap<QString, SKGPayeeObject> m_mapIdPayee;
};

#endif // SKGIMPORTPLUGINKMY_H
