// SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
// SPDX-FileCopyrightText: 2020-2022 Harald Sitter <sitter@kde.org>

#pragma once

// From winnt.h in mingw

#define ACTRL_RESERVED 0x00000000
#define ACTRL_PERM_1 0x00000001
#define ACTRL_PERM_2 0x00000002
#define ACTRL_PERM_3 0x00000004
#define ACTRL_PERM_4 0x00000008
#define ACTRL_PERM_5 0x00000010
#define ACTRL_PERM_6 0x00000020
#define ACTRL_PERM_7 0x00000040
#define ACTRL_PERM_8 0x00000080
#define ACTRL_PERM_9 0x00000100
#define ACTRL_PERM_10 0x00000200
#define ACTRL_PERM_11 0x00000400
#define ACTRL_PERM_12 0x00000800
#define ACTRL_PERM_13 0x00001000
#define ACTRL_PERM_14 0x00002000
#define ACTRL_PERM_15 0x00004000
#define ACTRL_PERM_16 0x00008000
#define ACTRL_PERM_17 0x00010000
#define ACTRL_PERM_18 0x00020000
#define ACTRL_PERM_19 0x00040000
#define ACTRL_PERM_20 0x00080000

#define ACTRL_ACCESS_ALLOWED 0x00000001
#define ACTRL_ACCESS_DENIED 0x00000002
#define ACTRL_AUDIT_SUCCESS 0x00000004
#define ACTRL_AUDIT_FAILURE 0x00000008

#define ACTRL_ACCESS_PROTECTED 0x00000001

#define ACTRL_SYSTEM_ACCESS 0x04000000
#define ACTRL_DELETE 0x08000000
#define ACTRL_READ_CONTROL 0x10000000
#define ACTRL_CHANGE_ACCESS 0x20000000
#define ACTRL_CHANGE_OWNER 0x40000000
#define ACTRL_SYNCHRONIZE 0x80000000
#define ACTRL_STD_RIGHTS_ALL 0xf8000000
#define ACTRL_STD_RIGHT_REQUIRED (ACTRL_STD_RIGHTS_ALL & ~ACTRL_SYNCHRONIZE)

#ifndef _DS_CONTROL_BITS_DEFINED_
#define _DS_CONTROL_BITS_DEFINED_

#define ACTRL_DS_OPEN ACTRL_RESERVED
#define ACTRL_DS_CREATE_CHILD ACTRL_PERM_1
#define ACTRL_DS_DELETE_CHILD ACTRL_PERM_2
#define ACTRL_DS_LIST ACTRL_PERM_3
#define ACTRL_DS_SELF ACTRL_PERM_4
#define ACTRL_DS_READ_PROP ACTRL_PERM_5
#define ACTRL_DS_WRITE_PROP ACTRL_PERM_6
#define ACTRL_DS_DELETE_TREE ACTRL_PERM_7
#define ACTRL_DS_LIST_OBJECT ACTRL_PERM_8
#define ACTRL_DS_CONTROL_ACCESS ACTRL_PERM_9
#endif

#define ACTRL_FILE_READ ACTRL_PERM_1
#define ACTRL_FILE_WRITE ACTRL_PERM_2
#define ACTRL_FILE_APPEND ACTRL_PERM_3
#define ACTRL_FILE_READ_PROP ACTRL_PERM_4
#define ACTRL_FILE_WRITE_PROP ACTRL_PERM_5
#define ACTRL_FILE_EXECUTE ACTRL_PERM_6
#define ACTRL_FILE_READ_ATTRIB ACTRL_PERM_8
#define ACTRL_FILE_WRITE_ATTRIB ACTRL_PERM_9
#define ACTRL_FILE_CREATE_PIPE ACTRL_PERM_10
#define ACTRL_DIR_LIST ACTRL_PERM_1
#define ACTRL_DIR_CREATE_OBJECT ACTRL_PERM_2
#define ACTRL_DIR_CREATE_CHILD ACTRL_PERM_3
#define ACTRL_DIR_DELETE_CHILD ACTRL_PERM_7
#define ACTRL_DIR_TRAVERSE ACTRL_PERM_6
#define ACTRL_KERNEL_TERMINATE ACTRL_PERM_1
#define ACTRL_KERNEL_THREAD ACTRL_PERM_2
#define ACTRL_KERNEL_VM ACTRL_PERM_3
#define ACTRL_KERNEL_VM_READ ACTRL_PERM_4
#define ACTRL_KERNEL_VM_WRITE ACTRL_PERM_5
#define ACTRL_KERNEL_DUP_HANDLE ACTRL_PERM_6
#define ACTRL_KERNEL_PROCESS ACTRL_PERM_7
#define ACTRL_KERNEL_SET_INFO ACTRL_PERM_8
#define ACTRL_KERNEL_GET_INFO ACTRL_PERM_9
#define ACTRL_KERNEL_CONTROL ACTRL_PERM_10
#define ACTRL_KERNEL_ALERT ACTRL_PERM_11
#define ACTRL_KERNEL_GET_CONTEXT ACTRL_PERM_12
#define ACTRL_KERNEL_SET_CONTEXT ACTRL_PERM_13
#define ACTRL_KERNEL_TOKEN ACTRL_PERM_14
#define ACTRL_KERNEL_IMPERSONATE ACTRL_PERM_15
#define ACTRL_KERNEL_DIMPERSONATE ACTRL_PERM_16
#define ACTRL_PRINT_SADMIN ACTRL_PERM_1
#define ACTRL_PRINT_SLIST ACTRL_PERM_2
#define ACTRL_PRINT_PADMIN ACTRL_PERM_3
#define ACTRL_PRINT_PUSE ACTRL_PERM_4
#define ACTRL_PRINT_JADMIN ACTRL_PERM_5
#define ACTRL_SVC_GET_INFO ACTRL_PERM_1
#define ACTRL_SVC_SET_INFO ACTRL_PERM_2
#define ACTRL_SVC_STATUS ACTRL_PERM_3
#define ACTRL_SVC_LIST ACTRL_PERM_4
#define ACTRL_SVC_START ACTRL_PERM_5
#define ACTRL_SVC_STOP ACTRL_PERM_6
#define ACTRL_SVC_PAUSE ACTRL_PERM_7
#define ACTRL_SVC_INTERROGATE ACTRL_PERM_8
#define ACTRL_SVC_UCONTROL ACTRL_PERM_9
#define ACTRL_REG_QUERY ACTRL_PERM_1
#define ACTRL_REG_SET ACTRL_PERM_2
#define ACTRL_REG_CREATE_CHILD ACTRL_PERM_3
#define ACTRL_REG_LIST ACTRL_PERM_4
#define ACTRL_REG_NOTIFY ACTRL_PERM_5
#define ACTRL_REG_LINK ACTRL_PERM_6
#define ACTRL_WIN_CLIPBRD ACTRL_PERM_1
#define ACTRL_WIN_GLOBAL_ATOMS ACTRL_PERM_2
#define ACTRL_WIN_CREATE ACTRL_PERM_3
#define ACTRL_WIN_LIST_DESK ACTRL_PERM_4
#define ACTRL_WIN_LIST ACTRL_PERM_5
#define ACTRL_WIN_READ_ATTRIBS ACTRL_PERM_6
#define ACTRL_WIN_WRITE_ATTRIBS ACTRL_PERM_7
#define ACTRL_WIN_SCREEN ACTRL_PERM_8
#define ACTRL_WIN_EXIT ACTRL_PERM_9
