/*
    SPDX-FileCopyrightText: Milian Wolff <mail@milianw.de>

    SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
*/

#ifndef KDEVPLATFORM_PLUGIN_QUICKOPENTESTBASE_H
#define KDEVPLATFORM_PLUGIN_QUICKOPENTESTBASE_H

#include <QObject>

#include <language/interfaces/quickopenfilter.h>

#include <tests/testcore.h>
#include <tests/testproject.h>

#include <project/projectmodel.h>

#include "../duchainitemquickopen.h"
#include "../projectfilequickopen.h"

#include <utility>

class QuickOpenTestBase
    : public QObject
{
    Q_OBJECT
public:
    explicit QuickOpenTestBase(KDevelop::TestCore::Setup setup, QObject* parent = nullptr);
private Q_SLOTS:
    void initTestCase();
    void cleanupTestCase();

    void cleanup();
protected:
    KDevelop::TestCore* core;
    KDevelop::TestCore::Setup setup;
    KDevelop::TestProjectController* projectController;
};

class PathTestFilter
    : public KDevelop::PathFilter<QString, PathTestFilter>
{
public:
    void setItems(QVector<QString> data)
    {
        updateItems([&data](QVector<QString>& oldData) {
            oldData = std::move(data);
        });
    }

    KDevelop::Path itemPath(const QString& data) const
    {
        return KDevelop::Path(data);
    }
    KDevelop::Path itemPrefixPath(const QString& /*data*/) const
    {
        return KDevelop::Path(QStringLiteral("/home/user/project"));
    }
};

KDevelop::TestProject* getProjectWithFiles(int files, const KDevelop::Path& path = {});

template <class T>
T* createChild(KDevelop::ProjectFolderItem* parent, const QString& childName)
{
    return new T(childName, parent);
}

QStringList items(const ProjectFileDataProvider& provider);

class TestFilter
    : public KDevelop::Filter<DUChainItem>
{
public:
    QString itemText(const DUChainItem& data) const override
    {
        return data.m_text;
    };
};

Q_DECLARE_METATYPE(QVector<DUChainItem>)

#endif // KDEVPLATFORM_PLUGIN_QUICKOPENTESTBASE_H
