/*
    Copyright 2014 Giorgos Tsiapaliokas <giorgos.tsiapaliokas@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the
    Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef PLASMATEEXTENSION_H
#define PLASMATEEXTENSION_H

#include <shell/shellextension.h>
#include <kdevplatform_version.h>


class PlasmateExtension : public KDevelop::ShellExtension {
public:
    static void init();

    virtual QString xmlFile();
#if KDEVPLATFORM_VERSION >= QT_VERSION_CHECK(5, 1, 40)
    virtual QString executableFilePath();
#else
    virtual QString binaryPath();
#endif
    virtual KDevelop::AreaParams defaultArea();
    virtual QString projectFileExtension();
    virtual QString projectFileDescription();
    virtual QStringList defaultPlugins();

protected:
    PlasmateExtension();
};

#endif








