/**
 * Copyright 2013 Albert Vaca <albertvaka@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KDECONNECTPLUGIN_H
#define KDECONNECTPLUGIN_H

#include <QObject>
#include <QVariantList>

#include <kdemacros.h>
#include <KPluginFactory>
#include <KPluginLoader>

#include "../networkpackage.h"
#include "../device.h"

class KDE_EXPORT KdeConnectPlugin
    : public QObject
{
    Q_OBJECT

public:
    KdeConnectPlugin(QObject* parent, const QVariantList& args);
    Device* device();

public Q_SLOTS:
    //Returns true if it has handled the package in some way
    //device.sendPackage can be used to send an answer back to the device
    virtual bool receivePackage(const NetworkPackage& np) = 0;
    virtual void connected() = 0;

private:
    Device* mDevice;

    // The Initializer object sets things up, and also does cleanup when it goes out of scope
    // Since the plugins use their own memory, they need their own initializer in order to send encrypted packages
    QCA::Initializer init;

};

#endif
