/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef KATEAPPLICATION_H
#define KATEAPPLICATION_H

// KDE includes
#include <dcopref.h>
#include <kurl.h>

// library includes
#include <workflow/application.h>

/**
 * @author Thomas Kadauke <tkadauke@gmx.de>
 */
class KateApplication : public WorKflow::Application
{
public:
  enum InsertPosition {
    CursorPosition,
    StartOfDocument,
    EndOfDocument
  };

  KateApplication(WorKflow::ApplicationDescription* app, const QString& dcopid);
  ~KateApplication();

  QValueList<DCOPRef> allDocuments();
  DCOPRef activeDocument();
  QString currentText();
  QString selectedText();
  void insertText(const QString& text, InsertPosition pos);

  void setCurrentText(const QString& text);
  bool setSelectedText(const QString& text);

  DCOPRef open(const KURL& url);

  virtual QStringList actions();
  virtual QString actionName(const QString& actionId);
  virtual void executeAction(const QString& actionId);

protected:
  DCOPRef mainWindow();
};

#endif
