/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>

// WorKflow includes
#include "widgetinterface.h"
#include "command.h"
#include "parameter.h"

using namespace WorKflow;

class WidgetInterface::Private
{
public:
  Command* command;
  Parameter* parameter;
  QString parameterId;
};

WidgetInterface::WidgetInterface()
{
  d = new Private;
  d->command = 0;
  d->parameter = 0;
}

WidgetInterface::~WidgetInterface()
{
  delete d;
}

Command* WorKflow::WidgetInterface::command()
{
  return d->command;
}

Parameter* WorKflow::WidgetInterface::parameter()
{
  return d->parameter;
}

void WidgetInterface::setCommand(Command* cmd)
{
  Parameter* param = getParameter(cmd, d->parameterId);
  if (!param)
    return;

  d->command = cmd;
  d->parameter = param;
}

void WidgetInterface::setParameterId(const QString& paramId)
{
  d->parameterId = paramId;
}

QString WidgetInterface::parameterId() const
{
  return d->parameterId;
}

Parameter* WidgetInterface::getParameter(Command* cmd, const QString& id)
{
  if (id.isEmpty()) {
    kdWarning() << k_funcinfo << "parameter id not set" << endl;
    return 0;
  }

  Parameter* param = cmd->parameter(id);
  if (!param) {
    kdWarning() << k_funcinfo << "could not find parameter " << id << " in command " << cmd->id() << endl;
    return 0;
  }

  return param;
}
