/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef CATEGORYLISTVIEW_H
#define CATEGORYLISTVIEW_H

// KDE includes
#include <klistview.h>

namespace WorKflow
{
  /**
   * ...
   *
   * There is a special category: if the ID is an empty string (""), then
   * the category is considered to be no category, which means that it
   * contains all available commands.
   *
   * @author Thomas Kadauke
   */
  class CategoryListView : public KListView
  {
    Q_OBJECT

  public:
    CategoryListView(QWidget* parent = 0, const char* name = 0);
    ~CategoryListView();

  public slots:
    void setFilter(const QString& string);

  signals:
    void categorySelected(const QString& category);

  protected slots:
    void populate();
    void slotSelectionChanged(QListViewItem* item);

  private:
    QString m_filter;
  };
}

#endif
