/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>
#include <ktrader.h>
#include <kregexpeditorinterface.h>
#include <kparts/componentfactory.h>

// Qt includes
#include <qdialog.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qradiobutton.h>

// WorKflow includes
#include "conversion.h"
#include "datatype.h"

// designer includes
#include "conversiondialog.h"
#include "selecttypedialog.h"

using namespace WorKflow;

bool ConversionDialog::editConversion(QWidget* parent, Conversion* desc)
{
  ConversionDialog dialog(parent, desc);
  return dialog.exec();
}

Conversion* ConversionDialog::newConversion(QWidget* parent, LibraryDescription* library)
{
  Conversion* type = new Conversion(library);

  ConversionDialog dialog(parent, type);
  if (dialog.exec())
    return dialog.m_conversion;
  else
    delete type;
  return 0;
}

ConversionDialog::ConversionDialog(QWidget* parent, Conversion* desc)
  : ConversionDialogBase(parent), m_conversion(desc)
{
  bool installed = !KTrader::self()->query("KRegExpEditor/KRegExpEditor").isEmpty();
  if (!installed) {
    m_editFilterButton->hide();
  }

  init();
}

ConversionDialog::~ConversionDialog()
{
}

void ConversionDialog::init()
{
  m_idEdit->setText(m_conversion->id());
  m_nameEdit->setText(m_conversion->name());
  m_descriptionEdit->setText(m_conversion->description());
  m_sourceTypeEdit->setText(m_conversion->sourceTypeId());
  m_destTypeEdit->setText(m_conversion->destTypeId());
  m_filterEdit->setText(m_conversion->grepExpression().pattern());

  switch (m_conversion->action()) {
    case Conversion::NoAction:
      m_doNothingRadio->setChecked(true);
      break;
    case Conversion::GrepAction:
      m_grepInputRadio->setChecked(true);
      break;
    case Conversion::ScriptAction:
      m_execScriptRadio->setChecked(true);
      break;
    case Conversion::CustomAction:
      m_cppRadio->setChecked(true);
      break;
  }
}

void ConversionDialog::accept()
{
  m_conversion->setId(m_idEdit->text());
  m_conversion->setName(m_nameEdit->text());
  m_conversion->setDescription(m_descriptionEdit->text());
  m_conversion->setSourceTypeId(m_sourceTypeEdit->text());
  m_conversion->setDestTypeId(m_destTypeEdit->text());
  m_conversion->setGrepExpression(QRegExp(m_filterEdit->text()));

  if (m_doNothingRadio->isChecked()) {
    m_conversion->setAction(Conversion::NoAction);
  } else if (m_grepInputRadio->isChecked()) {
    m_conversion->setAction(Conversion::GrepAction);
  } else if (m_execScriptRadio->isChecked()) {
    m_conversion->setAction(Conversion::ScriptAction);
  } else if (m_cppRadio->isChecked()) {
    m_conversion->setAction(Conversion::CustomAction);
  }

  QDialog::accept();
}

void ConversionDialog::browseSourceType()
{
  Datatype* type = SelectTypeDialog::select(this);
  if (type) {
    m_sourceTypeEdit->setText(type->id());
  }
}

void ConversionDialog::browseDestType()
{
  Datatype* type = SelectTypeDialog::select(this);
  if (type) {
    m_destTypeEdit->setText(type->id());
  }
}

void ConversionDialog::editFilter()
{
  QDialog* editorDialog = KParts::ComponentFactory::createInstanceFromQuery<QDialog>("KRegExpEditor/KRegExpEditor");
  if (editorDialog) {
    KRegExpEditorInterface* editor = static_cast<KRegExpEditorInterface*>(editorDialog->qt_cast("KRegExpEditorInterface"));
    Q_ASSERT(editor);

    editor->setRegExp(m_filterEdit->text());
    if (editorDialog->exec()) {
      m_filterEdit->setText(editor->regExp());
    }
  } else {
    kdWarning() << "Could not run regexp editor!" << endl;
  }
}

#include "conversiondialog.moc"
