/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kstandarddirs.h>
#include <kdebug.h>

// WorKflow includes
#include "library.h"
#include "commandfactory.h"
#include "applicationfactory.h"
#include "librarydescription.h"

using namespace WorKflow;

class Library::Private
{
public:
  typedef QValueList<CommandFactoryBase*> FactoryList;
  typedef QValueList<ApplicationFactoryBase*> AppFactoryList;

  LibraryDescription* desc;

  FactoryList factories;
  AppFactoryList appFactories;
};

Library::Library(QObject* parent, const char* name, const QStringList& /* args */)
  : QObject(parent, name)
{
  d = new Private;
  d->desc = 0;
}

Library::~Library()
{
  // delete all factories such that they will unregister themselves
  for (Private::FactoryList::Iterator i = d->factories.begin(); i != d->factories.end(); ++i)
    delete *i;

  for (Private::AppFactoryList::Iterator i = d->appFactories.begin(); i != d->appFactories.end(); ++i)
    delete *i;

  if (d->desc)
    delete d->desc;

  delete d;
}

void Library::addCommandFactory(CommandFactoryBase* factory)
{
  d->factories.append(factory);
}

void Library::addApplicationFactory(ApplicationFactoryBase* factory)
{
  d->appFactories.append(factory);
}

void Library::loadXML(const QString& libName)
{
  kdDebug() << k_funcinfo << "libname is " << libName << endl;

  KStandardDirs dirs;
  QString path = dirs.findResource("data", "workflow/libraries/" + libName + ".wflib");

  if (!path.isNull()) {
    d->desc = new LibraryDescription(path);
  }
}

#include "library.moc"
