/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>
#include <kapplication.h>
#include <dcopclient.h>
#include <kdebug.h>

#include "application.h"
#include "applicationdescription.h"

using namespace WorKflow;

Application::Application(ApplicationDescription* app, const QString& dcopid)
  : m_description(app), m_dcopName(dcopid)
{
  if (app)
    app->addInstance(this);
}

Application::~Application()
{
  if (m_description)
    m_description->removeInstance(this);
}


int Application::pid()
{
  //???
}

QString Application::dcopName()
{
  return m_dcopName;
}

QStringList Application::actions()
{
  return QStringList();
}

QString Application::actionName(const QString& /* actionId */)
{
  return QString::null;
}

void Application::executeAction(const QString& /* actionId */)
{
}

void Application::terminate()
{
  DCOPClient* client = kapp->dcopClient();

  // quit application
  QByteArray data;
  if (!client->send(m_dcopName.utf8(), "MainApplication-Interface", "quit()", data))
    kdWarning() << "Could not quit application " << m_dcopName << " over DCOP" << endl;

  m_running = false;
}

bool Application::isUnique()
{
  if (m_description)
    return m_description->isUnique();
  return false;
}

bool Application::isRunning()
{
  return m_running;
}

QString WorKflow::Application::id()
{
  return m_description->id();
}
