/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef PREVIEWWIDGET_H
#define PREVIEWWIDGET_H

#include "previewwidgetbase.h"

class PreviewWidget : public PreviewWidgetBase
{
  Q_OBJECT

public:
  PreviewWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~PreviewWidget();

  void setOriginalImage(const QString& fileName);
  void setProcessedImage(const QString& fileName);
  QString originalImagePath() const;

signals:
  void imageDropped(const QString& fileName);

private slots:
  virtual void slotDropped(const QString& fileName);
  void init();
  void updatePreview();

private:
  QString m_imagePath;
};

#endif

