// Qt includes
#include <qobject.h>
#include <qstring.h>

// kmtraceviewer includes
#include "KMtraceSuppression.hh"
#include "KMtraceSuppression.moc"
#include "KMtraceSuppressionViewItem.hh"


KMtraceSuppression::KMtraceSuppression( QString string, KMtraceSuppressionMethod method )
  : QObject( )
{
   this->string = string;
   this->method = method;
}

QString KMtraceSuppression::getLeakType( )
{
   return QString( "Memory Leak" );
}

KMtraceSuppressionMethod KMtraceSuppression::getMethod( )
{
   return method;
}

QString KMtraceSuppression::getMethodAsString( )
{
   switch( method )
   {
      case MatchByString:
         return QString( "string match" );
      case Comment:
         return QString( "comment" );
   }
}

QString KMtraceSuppression::getDescription( )
{
   return string;
}

void KMtraceSuppression::setView( QObject *view )
{
   this->view = view;
}

QObject *KMtraceSuppression::getView( )
{
   return view;
}
